/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class UnsavedChangesDialog {
    private static final String SAVE_AND_CLOSE = "Save Changes";
    private static final String CLOSE_WITHOUT_SAVE = "Discard Changes";
    private static final String CANCEL = "Cancel";
    private JButton saveButton = new JButton("Save Changes");
    private JButton withoutSaveButton = new JButton("Discard Changes");
    private JButton cancelButton = new JButton("Cancel");
    protected Component parent;
    protected String result = "Cancel";

    public UnsavedChangesDialog(Component parent) {
        this.parent = parent;
        this.initButtons();
    }

    public void show() {
        JOptionPane pane = new JOptionPane("You have unsaved changes. Do you want to save them?", 3);
        pane.setOptions(new Object[]{this.saveButton, this.withoutSaveButton, this.cancelButton});
        JDialog dialog = pane.createDialog(this.parent, "Unsaved Changes");
        dialog.setVisible(true);
        Object selectedValue = pane.getValue();
        this.result = SAVE_AND_CLOSE.equals(selectedValue) ? SAVE_AND_CLOSE : (CLOSE_WITHOUT_SAVE.equals(selectedValue) ? CLOSE_WITHOUT_SAVE : CANCEL);
    }

    private void initButtons() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane pane = UnsavedChangesDialog.this.getOptionPane((JComponent)e.getSource());
                pane.setValue(e.getActionCommand());
            }
        };
        this.saveButton.addActionListener(listener);
        this.withoutSaveButton.addActionListener(listener);
        this.cancelButton.addActionListener(listener);
    }

    private JOptionPane getOptionPane(JComponent parent) {
        JOptionPane pane = null;
        pane = !(parent instanceof JOptionPane) ? this.getOptionPane((JComponent)parent.getParent()) : (JOptionPane)parent;
        return pane;
    }

    public boolean shouldSave() {
        return SAVE_AND_CLOSE.equals(this.result);
    }

    public boolean shouldNotSave() {
        return CLOSE_WITHOUT_SAVE.equals(this.result);
    }

    public boolean shouldCancel() {
        return this.result == null || CANCEL.equals(this.result);
    }
}

