/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.autorelationship;

import java.awt.Component;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.map.naming.ObjectNameGenerator;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ClassLoadingService;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.ErrorDebugDialog;
import org.apache.cayenne.modeler.dialog.autorelationship.InferRelationshipsControllerBase;
import org.apache.cayenne.modeler.dialog.autorelationship.InferRelationshipsDialog;
import org.apache.cayenne.modeler.dialog.autorelationship.InferRelationshipsTabController;
import org.apache.cayenne.modeler.dialog.autorelationship.InferredRelationship;
import org.apache.cayenne.modeler.undo.CreateRelationshipUndoableEdit;
import org.apache.cayenne.modeler.undo.InferRelationshipsUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.NameGeneratorPreferences;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InferRelationshipsController
extends InferRelationshipsControllerBase {
    public static final int SELECT = 1;
    public static final int CANCEL = 0;
    private static Log logObj = LogFactory.getLog(ErrorDebugDialog.class);
    protected InferRelationshipsDialog view;
    protected InferRelationshipsTabController entitySelector;
    protected ObjectNameGenerator strategy = this.createNamingStrategy(NameGeneratorPreferences.getInstance().getLastUsedStrategies().get(0));

    public InferRelationshipsController(CayenneController parent, DataMap dataMap) {
        super(parent, dataMap);
        this.setNamingStrategy(this.strategy);
        this.setRelationships();
        this.entitySelector = new InferRelationshipsTabController(this);
    }

    public ObjectNameGenerator createNamingStrategy(String strategyClass) {
        try {
            ClassLoadingService classLoader = this.application.getClassLoadingService();
            return classLoader.loadClass(ObjectNameGenerator.class, strategyClass).newInstance();
        }
        catch (Throwable th) {
            logObj.error((Object)("Error in " + this.getClass().getName()), th);
            JOptionPane.showMessageDialog(this.view, "Naming Strategy Initialization Error: " + th.getMessage(), "Naming Strategy Initialization Error", 0);
            return null;
        }
    }

    @Override
    public Component getView() {
        return this.view;
    }

    public void startup() {
        this.view = new InferRelationshipsDialog(this.entitySelector.getView());
        this.initBindings();
        this.view.pack();
        this.view.setModal(true);
        this.centerView();
        this.makeCloseableOnEscape();
        this.view.setVisible(true);
    }

    protected void initBindings() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getCancelButton(), "cancelAction()");
        builder.bindToAction(this.view.getGenerateButton(), "generateAction()");
        builder.bindToAction(this, "entitySelectedAction()", "selected");
        builder.bindToAction(this.view.getStrategyCombo(), "strategyComboAction()");
    }

    public void entitySelectedAction() {
        int size = this.getSelectedEntitiesSize();
        String label = size == 0 ? "No DbRelationships selected" : (size == 1 ? "One DbRelationships selected" : size + " DbRelationships selected");
        this.view.getEntityCount().setText(label);
    }

    public void strategyComboAction() {
        try {
            String strategyClass = (String)this.view.getStrategyCombo().getSelectedItem();
            this.strategy = this.createNamingStrategy(strategyClass);
            if (this.strategy == null) {
                return;
            }
            NameGeneratorPreferences.getInstance().addToLastUsedStrategies(strategyClass);
            this.view.getStrategyCombo().setModel(new DefaultComboBoxModel<String>(NameGeneratorPreferences.getInstance().getLastUsedStrategies()));
        }
        catch (Throwable th) {
            logObj.error((Object)("Error in " + this.getClass().getName()), th);
            return;
        }
        this.setNamingStrategy(this.strategy);
        this.createNames();
        this.entitySelector.initBindings();
        this.view.setChoice(1);
    }

    public ObjectNameGenerator getNamingStrategy() {
        return this.strategy;
    }

    public void cancelAction() {
        this.view.dispose();
    }

    public void generateAction() {
        ProjectController mediator = this.application.getFrameController().getProjectController();
        InferRelationshipsUndoableEdit undoableEdit = new InferRelationshipsUndoableEdit();
        for (InferredRelationship temp : this.selectedEntities) {
            DbRelationship rel = new DbRelationship(this.uniqueRelName((Entity)temp.getSource(), temp.getName()));
            RelationshipEvent e = new RelationshipEvent((Object)Application.getFrame(), (Relationship)rel, (Entity)temp.getSource(), 2);
            mediator.fireDbRelationshipEvent(e);
            rel.setSourceEntity((Entity)temp.getSource());
            rel.setTargetEntityName((Entity)temp.getTarget());
            DbJoin join = new DbJoin(rel, temp.getJoinSource().getName(), temp.getJoinTarget().getName());
            rel.addJoin(join);
            rel.setToMany(temp.isToMany());
            temp.getSource().addRelationship((Relationship)rel);
            undoableEdit.addEdit(new CreateRelationshipUndoableEdit(temp.getSource(), new DbRelationship[]{rel}));
        }
        JOptionPane.showMessageDialog(this.getView(), this.getSelectedEntitiesSize() + " relationships generated");
        this.view.dispose();
    }

    private String uniqueRelName(Entity entity, String preferredName) {
        int currentSuffix = 1;
        String relName = preferredName;
        while (entity.getRelationship(relName) != null || entity.getAttribute(relName) != null) {
            relName = preferredName + currentSuffix;
            ++currentSuffix;
        }
        return relName;
    }
}

