/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.codegen;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.gen.ClientClassGenerationAction;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.dialog.codegen.CodeGeneratorControllerBase;
import org.apache.cayenne.modeler.dialog.codegen.GeneratorControllerPanel;
import org.apache.cayenne.modeler.dialog.codegen.StandardModeController;
import org.apache.cayenne.modeler.dialog.codegen.StandardModePanel;
import org.apache.cayenne.modeler.dialog.codegen.StandardPanelComponent;
import org.apache.cayenne.modeler.pref.DataMapDefaults;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.validation.BeanValidationFailure;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;
import org.apache.commons.collections.Predicate;

public class ClientModeController
extends StandardModeController {
    protected Predicate checkPredicate = new Predicate(){

        public boolean evaluate(Object object) {
            if (object instanceof ObjEntity) {
                ObjEntity entity = (ObjEntity)object;
                return entity.isClientAllowed() && ClientModeController.this.getParentController().getProblem(entity.getName()) == null;
            }
            return false;
        }
    };

    public ClientModeController(CodeGeneratorControllerBase parent) {
        super(parent);
    }

    public void validateEntity(ValidationResult validationBuffer, ObjEntity entity) {
        if (!entity.isClientAllowed()) {
            validationBuffer.addFailure((ValidationFailure)new BeanValidationFailure((Object)entity.getName(), "clientAllowed", (Object)"Not a client entity"));
        } else {
            super.validateEntity(validationBuffer, entity, true);
        }
    }

    @Override
    protected void createDefaults() {
        TreeMap<DataMap, DataMapDefaults> map = new TreeMap<DataMap, DataMapDefaults>();
        ArrayList dataMaps = (ArrayList)this.getParentController().getDataMaps();
        for (DataMap dataMap : dataMaps) {
            DataMapDefaults preferences = this.getApplication().getFrameController().getProjectController().getDataMapPreferences(this.getClass().getName().replace(".", "/"), dataMap);
            preferences.setSuperclassPackage("");
            preferences.updateSuperclassPackage(dataMap, true);
            map.put(dataMap, preferences);
            if (this.getOutputPath() != null) continue;
            this.setOutputPath(preferences.getOutputPath());
        }
        this.setMapPreferences(map);
    }

    @Override
    protected GeneratorControllerPanel createView() {
        this.view = new StandardModePanel();
        Set<Map.Entry<DataMap, DataMapDefaults>> entities = this.getMapPreferences().entrySet();
        for (Map.Entry<DataMap, DataMapDefaults> entry : entities) {
            StandardPanelComponent dataMapLine = this.createDataMapLineBy(entry.getKey(), entry.getValue());
            dataMapLine.getDataMapName().setText(dataMapLine.getDataMap().getName());
            BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), dataMapLine);
            builder.bindToTextField(dataMapLine.getSuperclassPackage(), "preferences.superclassPackage").updateView();
            this.view.addDataMapLine(dataMapLine);
        }
        return this.view;
    }

    private StandardPanelComponent createDataMapLineBy(DataMap dataMap, DataMapDefaults preferences) {
        StandardPanelComponent dataMapLine = new StandardPanelComponent();
        dataMapLine.setDataMap(dataMap);
        dataMapLine.setPreferences(preferences);
        return dataMapLine;
    }

    @Override
    protected ClassGenerationAction newGenerator() {
        return new ClientClassGenerationAction();
    }

    public Predicate getDefaultEntityFilter() {
        return this.checkPredicate;
    }
}

