/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.codegen;

import java.awt.Component;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.dialog.ErrorDebugDialog;
import org.apache.cayenne.modeler.dialog.codegen.ClassesTabController;
import org.apache.cayenne.modeler.dialog.codegen.CodeGeneratorControllerBase;
import org.apache.cayenne.modeler.dialog.codegen.CodeGeneratorDialog;
import org.apache.cayenne.modeler.dialog.codegen.GeneratorController;
import org.apache.cayenne.modeler.dialog.codegen.GeneratorTabController;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CodeGeneratorController
extends CodeGeneratorControllerBase {
    private static Log logObj = LogFactory.getLog(ErrorDebugDialog.class);
    protected CodeGeneratorDialog view;
    protected ClassesTabController classesSelector = new ClassesTabController(this);
    protected GeneratorTabController generatorSelector = new GeneratorTabController(this);

    public CodeGeneratorController(CayenneController parent, Collection<DataMap> dataMaps) {
        super(parent, dataMaps);
    }

    @Override
    public Component getView() {
        return this.view;
    }

    public void startup() {
        this.view = new CodeGeneratorDialog(this.generatorSelector.getView(), this.classesSelector.getView());
        this.initBindings();
        this.view.pack();
        this.view.setModal(true);
        this.centerView();
        this.makeCloseableOnEscape();
        this.view.setVisible(true);
    }

    protected void initBindings() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getCancelButton(), "cancelAction()");
        builder.bindToAction(this.view.getGenerateButton(), "generateAction()");
        builder.bindToAction(this, "classesSelectedAction()", "selected");
        builder.bindToAction(this.generatorSelector, "generatorSelectedAction()", "generator");
        this.generatorSelectedAction();
    }

    public void generatorSelectedAction() {
        GeneratorController controller = this.generatorSelector.getGeneratorController();
        this.validate(controller);
        Predicate predicate = controller != null ? controller.getDefaultClassFilter() : PredicateUtils.falsePredicate();
        this.updateSelection(predicate);
        this.classesSelector.classSelectedAction();
    }

    public void classesSelectedAction() {
        int size = this.getSelectedEntitiesSize();
        String label = size == 0 ? "No entities selected" : (size == 1 ? "One entity selected" : size + " entities selected");
        label = label.concat("; ");
        int sizeEmb = this.getSelectedEmbeddablesSize();
        label = sizeEmb == 0 ? label + "No embeddables selected" : (sizeEmb == 1 ? label + "One embeddable selected" : label + sizeEmb + " embeddables selected");
        this.view.getClassesCount().setText(label);
    }

    public void cancelAction() {
        this.view.dispose();
    }

    public void generateAction() {
        Collection<ClassGenerationAction> generators = this.generatorSelector.getGenerator();
        if (generators != null) {
            try {
                for (ClassGenerationAction generator : generators) {
                    generator.execute();
                }
                JOptionPane.showMessageDialog(this.getView(), "Class generation finished");
            }
            catch (Exception e) {
                logObj.error((Object)"Error generating classes", (Throwable)e);
                JOptionPane.showMessageDialog(this.getView(), "Error generating classes - " + e.getMessage());
            }
        }
        this.view.dispose();
    }
}

