/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.codegen;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.CodeTemplateManager;
import org.apache.cayenne.modeler.dialog.codegen.CodeGeneratorControllerBase;
import org.apache.cayenne.modeler.dialog.codegen.CustomModePanel;
import org.apache.cayenne.modeler.dialog.codegen.CustomPreferencesUpdater;
import org.apache.cayenne.modeler.dialog.codegen.GeneratorController;
import org.apache.cayenne.modeler.dialog.codegen.GeneratorControllerPanel;
import org.apache.cayenne.modeler.dialog.codegen.StandardPanelComponent;
import org.apache.cayenne.modeler.dialog.pref.PreferenceDialog;
import org.apache.cayenne.modeler.pref.DataMapDefaults;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.ObjectBinding;
import org.apache.cayenne.util.Util;

public class CustomModeController
extends GeneratorController {
    static final String MODE_DATAMAP = "datamap";
    static final String MODE_ENTITY = "entity";
    static final String MODE_ALL = "all";
    static final String DATA_MAP_MODE_LABEL = "DataMap generation";
    static final String ENTITY_MODE_LABEL = "Entity and Embeddable generation";
    static final String ALL_MODE_LABEL = "Generate all";
    static final Map<String, String> modesByLabel = new HashMap<String, String>();
    protected CustomModePanel view;
    protected CodeTemplateManager templateManager;
    protected ObjectBinding superTemplate;
    protected ObjectBinding subTemplate;
    private CustomPreferencesUpdater preferencesUpdater;

    public CustomPreferencesUpdater getCustomPreferencesUpdater() {
        return this.preferencesUpdater;
    }

    public CustomModeController(CodeGeneratorControllerBase parent) {
        super(parent);
        Object[] modeChoices = new Object[]{ENTITY_MODE_LABEL, DATA_MAP_MODE_LABEL, ALL_MODE_LABEL};
        this.view.getGenerationMode().setModel(new DefaultComboBoxModel<Object>(modeChoices));
        Set<Map.Entry<DataMap, DataMapDefaults>> entities = this.getMapPreferences().entrySet();
        for (Map.Entry<DataMap, DataMapDefaults> entry : entities) {
            if (Util.isEmptyString((String)entry.getValue().getSuperclassTemplate())) {
                entry.getValue().setSuperclassTemplate("Standard Server Superclass");
            }
            if (Util.isEmptyString((String)entry.getValue().getSubclassTemplate())) {
                entry.getValue().setSubclassTemplate("Standard Server Subclass");
            }
            if (Util.isEmptyString((String)entry.getValue().getProperty("mode"))) {
                entry.getValue().setProperty("mode", MODE_ENTITY);
            }
            if (Util.isEmptyString((String)entry.getValue().getProperty("overwrite"))) {
                entry.getValue().setBooleanProperty("overwrite", false);
            }
            if (Util.isEmptyString((String)entry.getValue().getProperty("pairs"))) {
                entry.getValue().setBooleanProperty("pairs", true);
            }
            if (Util.isEmptyString((String)entry.getValue().getProperty("usePackagePath"))) {
                entry.getValue().setBooleanProperty("usePackagePath", true);
            }
            if (!Util.isEmptyString((String)entry.getValue().getProperty("outputPattern"))) continue;
            entry.getValue().setProperty("outputPattern", "*.java");
        }
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getManageTemplatesLink(), "popPreferencesAction()");
        builder.bindToComboSelection(this.view.getGenerationMode(), "customPreferencesUpdater.mode").updateView();
        builder.bindToStateChange(this.view.getOverwrite(), "customPreferencesUpdater.overwrite").updateView();
        builder.bindToStateChange(this.view.getPairs(), "customPreferencesUpdater.pairs").updateView();
        builder.bindToStateChange(this.view.getUsePackagePath(), "customPreferencesUpdater.usePackagePath").updateView();
        this.subTemplate = builder.bindToComboSelection(this.view.getSubclassTemplate(), "customPreferencesUpdater.subclassTemplate");
        this.superTemplate = builder.bindToComboSelection(this.view.getSuperclassTemplate(), "customPreferencesUpdater.superclassTemplate");
        builder.bindToTextField(this.view.getOutputPattern(), "customPreferencesUpdater.outputPattern").updateView();
        this.updateTemplates();
    }

    @Override
    protected void createDefaults() {
        TreeMap<DataMap, DataMapDefaults> map = new TreeMap<DataMap, DataMapDefaults>();
        Collection<DataMap> dataMaps = this.getParentController().getDataMaps();
        for (DataMap dataMap : dataMaps) {
            DataMapDefaults preferences = this.getApplication().getFrameController().getProjectController().getDataMapPreferences(this.getClass().getName().replace(".", "/"), dataMap);
            preferences.setSuperclassPackage("");
            preferences.updateSuperclassPackage(dataMap, false);
            map.put(dataMap, preferences);
            if (this.getOutputPath() != null) continue;
            this.setOutputPath(preferences.getOutputPath());
        }
        this.setMapPreferences(map);
        this.preferencesUpdater = new CustomPreferencesUpdater(map);
    }

    @Override
    protected GeneratorControllerPanel createView() {
        this.view = new CustomModePanel();
        Set<Map.Entry<DataMap, DataMapDefaults>> entities = this.getMapPreferences().entrySet();
        for (Map.Entry<DataMap, DataMapDefaults> entry : entities) {
            StandardPanelComponent dataMapLine = this.createDataMapLineBy(entry.getKey(), entry.getValue());
            dataMapLine.getDataMapName().setText(dataMapLine.getDataMap().getName());
            BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), dataMapLine);
            builder.bindToTextField(dataMapLine.getSuperclassPackage(), "preferences.superclassPackage").updateView();
            this.view.addDataMapLine(dataMapLine);
        }
        return this.view;
    }

    private StandardPanelComponent createDataMapLineBy(DataMap dataMap, DataMapDefaults preferences) {
        StandardPanelComponent dataMapLine = new StandardPanelComponent();
        dataMapLine.setDataMap(dataMap);
        dataMapLine.setPreferences(preferences);
        return dataMapLine;
    }

    protected void updateTemplates() {
        this.templateManager = this.getApplication().getCodeTemplateManager();
        ArrayList<String> customTemplates = new ArrayList<String>(this.templateManager.getCustomTemplates().keySet());
        Collections.sort(customTemplates);
        ArrayList<String> superTemplates = new ArrayList<String>(this.templateManager.getStandardSuperclassTemplates());
        Collections.sort(superTemplates);
        superTemplates.addAll(customTemplates);
        ArrayList<String> subTemplates = new ArrayList<String>(this.templateManager.getStandardSubclassTemplates());
        Collections.sort(subTemplates);
        subTemplates.addAll(customTemplates);
        this.view.getSubclassTemplate().setModel(new DefaultComboBoxModel<Object>(subTemplates.toArray()));
        this.view.getSuperclassTemplate().setModel(new DefaultComboBoxModel<Object>(superTemplates.toArray()));
        this.superTemplate.updateView();
        this.subTemplate.updateView();
    }

    @Override
    public Component getView() {
        return this.view;
    }

    @Override
    public Collection<ClassGenerationAction> createGenerator() {
        this.mode = modesByLabel.get(this.view.getGenerationMode().getSelectedItem()).toString();
        Collection<ClassGenerationAction> generators = super.createGenerator();
        String superKey = this.view.getSuperclassTemplate().getSelectedItem().toString();
        String superTemplate = this.templateManager.getTemplatePath(superKey);
        String subKey = this.view.getSubclassTemplate().getSelectedItem().toString();
        String subTemplate = this.templateManager.getTemplatePath(subKey);
        for (ClassGenerationAction generator : generators) {
            generator.setSuperTemplate(superTemplate);
            generator.setTemplate(subTemplate);
            generator.setOverwrite(this.view.getOverwrite().isSelected());
            generator.setUsePkgPath(this.view.getUsePackagePath().isSelected());
            generator.setMakePairs(this.view.getPairs().isSelected());
            if (Util.isEmptyString((String)this.view.getOutputPattern().getText())) continue;
            generator.setOutputPattern(this.view.getOutputPattern().getText());
        }
        return generators;
    }

    public void popPreferencesAction() {
        new PreferenceDialog(this.getApplication().getFrameController()).startupAction("Templates");
        this.updateTemplates();
    }

    @Override
    protected ClassGenerationAction newGenerator() {
        return new ClassGenerationAction();
    }

    static {
        modesByLabel.put(DATA_MAP_MODE_LABEL, MODE_DATAMAP);
        modesByLabel.put(ENTITY_MODE_LABEL, MODE_ENTITY);
        modesByLabel.put(ALL_MODE_LABEL, MODE_ALL);
    }
}

