/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.codegen;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.cayenne.gen.ArtifactsGenerationMode;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.dialog.codegen.CodeGeneratorControllerBase;
import org.apache.cayenne.modeler.dialog.codegen.GeneratorController;
import org.apache.cayenne.modeler.dialog.codegen.GeneratorControllerPanel;
import org.apache.cayenne.modeler.dialog.codegen.StandardModePanel;
import org.apache.cayenne.modeler.dialog.codegen.StandardPanelComponent;
import org.apache.cayenne.modeler.pref.DataMapDefaults;
import org.apache.cayenne.swing.BindingBuilder;

public class StandardModeController
extends GeneratorController {
    protected StandardModePanel view;
    protected DataMapDefaults preferences;

    public StandardModeController(CodeGeneratorControllerBase parent) {
        super(parent);
    }

    @Override
    protected void createDefaults() {
        TreeMap<DataMap, DataMapDefaults> treeMap = new TreeMap<DataMap, DataMapDefaults>();
        ArrayList dataMaps = (ArrayList)this.getParentController().getDataMaps();
        for (DataMap dataMap : dataMaps) {
            DataMapDefaults preferences = this.getApplication().getFrameController().getProjectController().getDataMapPreferences(dataMap);
            preferences.setSuperclassPackage("");
            preferences.updateSuperclassPackage(dataMap, false);
            treeMap.put(dataMap, preferences);
            if (this.getOutputPath() != null) continue;
            this.setOutputPath(preferences.getOutputPath());
        }
        this.setMapPreferences(treeMap);
    }

    @Override
    protected GeneratorControllerPanel createView() {
        this.view = new StandardModePanel();
        Set<Map.Entry<DataMap, DataMapDefaults>> entities = this.getMapPreferences().entrySet();
        for (Map.Entry<DataMap, DataMapDefaults> entry : entities) {
            StandardPanelComponent dataMapLine = this.createDataMapLineBy(entry.getKey(), entry.getValue());
            dataMapLine.getDataMapName().setText(dataMapLine.getDataMap().getName());
            BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), dataMapLine);
            builder.bindToTextField(dataMapLine.getSuperclassPackage(), "preferences.superclassPackage").updateView();
            this.view.addDataMapLine(dataMapLine);
        }
        return this.view;
    }

    private StandardPanelComponent createDataMapLineBy(DataMap dataMap, DataMapDefaults preferences) {
        StandardPanelComponent dataMapLine = new StandardPanelComponent();
        dataMapLine.setDataMap(dataMap);
        dataMapLine.setPreferences(preferences);
        return dataMapLine;
    }

    @Override
    public Component getView() {
        return this.view;
    }

    @Override
    protected ClassGenerationAction newGenerator() {
        return new ClassGenerationAction();
    }

    @Override
    public Collection<ClassGenerationAction> createGenerator() {
        this.mode = ArtifactsGenerationMode.ALL.getLabel();
        return super.createGenerator();
    }
}

