/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.datadomain;

import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.ProjectTreeModel;
import org.apache.cayenne.modeler.ProjectTreeView;

public class FilterController {
    private HashMap<String, Boolean> filterMap = new HashMap();
    private ProjectTreeView tree;
    private ProjectController eventController;
    private ProjectTreeModel treeModel;

    public ProjectTreeView getTree() {
        return this.tree;
    }

    public ProjectTreeModel getTreeModel() {
        return this.treeModel;
    }

    public ProjectController getEventController() {
        return this.eventController;
    }

    public HashMap<String, Boolean> getFilterMap() {
        return this.filterMap;
    }

    public FilterController(ProjectController eventController, ProjectTreeView treePanel) {
        this.eventController = eventController;
        this.tree = treePanel;
        this.treeModel = this.tree.getProjectModel();
        this.filterMap.put("dbEntity", true);
        this.filterMap.put("objEntity", true);
        this.filterMap.put("embeddable", true);
        this.filterMap.put("procedure", true);
        this.filterMap.put("query", true);
    }

    public void treeExpOrCollPath(String action) {
        TreeNode root = (TreeNode)this.treeModel.getRoot();
        this.expandAll(this.tree, new TreePath(root), action);
    }

    private void expandAll(JTree tree, TreePath parent, String action) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, action);
            }
        }
        if (action == "expand") {
            tree.expandPath(parent);
        } else if (action == "collapse") {
            this.treeModel.reload(this.treeModel.getRootNode());
        }
    }
}

