/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.datadomain;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.datadomain.FilterController;
import org.apache.cayenne.swing.BindingBuilder;

public class FilterDialog
extends JPopupMenu {
    private String SHOW_ALL = "Show all";
    private JCheckBoxMenuItem dbEntity;
    private JCheckBoxMenuItem objEntity;
    private JCheckBoxMenuItem embeddable;
    private JCheckBoxMenuItem procedure;
    private JCheckBoxMenuItem query;
    private JCheckBoxMenuItem all;
    private ProjectController eventController;
    private FilterController filterController;

    public Boolean getDbEntityFilter() {
        return this.filterController.getFilterMap().get("dbEntity");
    }

    public void setDbEntityFilter(Boolean value) {
        this.filterController.getFilterMap().put("dbEntity", value);
    }

    public Boolean getObjEntityFilter() {
        return this.filterController.getFilterMap().get("objEntity");
    }

    public void setObjEntityFilter(Boolean value) {
        this.filterController.getFilterMap().put("objEntity", value);
    }

    public Boolean getEmbeddableFilter() {
        return this.filterController.getFilterMap().get("embeddable");
    }

    public void setEmbeddableFilter(Boolean value) {
        this.filterController.getFilterMap().put("embeddable", value);
    }

    public Boolean getProcedureFilter() {
        return this.filterController.getFilterMap().get("procedure");
    }

    public void setProcedureFilter(Boolean value) {
        this.filterController.getFilterMap().put("procedure", value);
    }

    public Boolean getQueryFilter() {
        return this.filterController.getFilterMap().get("query");
    }

    public void setQueryFilter(Boolean value) {
        this.filterController.getFilterMap().put("query", value);
    }

    public Boolean getAllFilter() {
        Set<String> keys = this.filterController.getFilterMap().keySet();
        for (String key : keys) {
            if (this.filterController.getFilterMap().get(key).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public void setAllFilter(Boolean value) {
    }

    public FilterDialog(FilterController filterController) {
        this.filterController = filterController;
        this.eventController = filterController.getEventController();
        this.initView();
        this.initController();
    }

    public void initView() {
        this.all = new JCheckBoxMenuItem(this.SHOW_ALL);
        this.dbEntity = new JCheckBoxMenuItem("DbEntity");
        this.objEntity = new JCheckBoxMenuItem("ObjEntity");
        this.embeddable = new JCheckBoxMenuItem("Embeddable");
        this.procedure = new JCheckBoxMenuItem("Procedure");
        this.query = new JCheckBoxMenuItem("Query");
        this.add(this.all);
        this.addSeparator();
        this.add(this.dbEntity);
        this.add(this.objEntity);
        this.add(this.embeddable);
        this.add(this.procedure);
        this.add(this.query);
    }

    private void initController() {
        BindingBuilder builder = new BindingBuilder(this.eventController.getApplication().getBindingFactory(), this);
        builder.bindToStateChange(this.dbEntity, "dbEntityFilter").updateView();
        builder.bindToStateChange(this.objEntity, "objEntityFilter").updateView();
        builder.bindToStateChange(this.embeddable, "embeddableFilter").updateView();
        builder.bindToStateChange(this.procedure, "procedureFilter").updateView();
        builder.bindToStateChange(this.query, "queryFilter").updateView();
        builder.bindToStateChange(this.all, "allFilter").updateView();
        this.dbEntity.addActionListener(new CheckListener("dbEntity"));
        this.objEntity.addActionListener(new CheckListener("objEntity"));
        this.embeddable.addActionListener(new CheckListener("embeddable"));
        this.procedure.addActionListener(new CheckListener("procedure"));
        this.query.addActionListener(new CheckListener("query"));
        this.all.setEnabled(false);
        this.all.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterDialog.this.dbEntity.setSelected(true);
                FilterDialog.this.objEntity.setSelected(true);
                FilterDialog.this.embeddable.setSelected(true);
                FilterDialog.this.procedure.setSelected(true);
                FilterDialog.this.query.setSelected(true);
                FilterDialog.this.all.setEnabled(false);
                FilterDialog.this.filterController.getTreeModel().setFiltered(FilterDialog.this.filterController.getFilterMap());
                FilterDialog.this.filterController.getTree().updateUI();
            }
        });
    }

    void checkAllStates() {
        if (!this.isAll()) {
            this.all.setSelected(false);
            this.all.setEnabled(true);
        } else {
            this.all.setSelected(true);
            this.all.setEnabled(false);
        }
    }

    private boolean isAll() {
        Set<String> keys = this.filterController.getFilterMap().keySet();
        for (String key : keys) {
            if (this.filterController.getFilterMap().get(key).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private class CheckListener
    implements ActionListener {
        String key;

        public CheckListener(String key) {
            this.key = key;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterDialog.this.filterController.getFilterMap().put(this.key, ((JCheckBoxMenuItem)e.getSource()).isSelected());
            FilterDialog.this.filterController.getTreeModel().setFiltered(FilterDialog.this.filterController.getFilterMap());
            FilterDialog.this.filterController.getTree().updateUI();
            FilterDialog.this.checkAllStates();
        }
    }
}

