/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.datamap;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.cayenne.configuration.event.ProcedureEvent;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.datamap.DefaultsPreferencesController;
import org.apache.cayenne.modeler.dialog.datamap.DefaultsPreferencesView;
import org.apache.cayenne.util.Util;

public class CatalogUpdateController
extends DefaultsPreferencesController {
    public static final String ALL_CONTROL = "Set/update catalog for all DbEntities";
    public static final String UNINIT_CONTROL = "Do not override existing non-empty catalog";
    protected DefaultsPreferencesView view;

    public CatalogUpdateController(ProjectController mediator, DataMap dataMap) {
        super(mediator, dataMap);
    }

    public void startupAction() {
        this.view = new DefaultsPreferencesView(ALL_CONTROL, UNINIT_CONTROL);
        this.view.setTitle("Update DbEntities Catalog");
        this.initController();
        this.view.pack();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
    }

    @Override
    public Component getView() {
        return this.view;
    }

    private void initController() {
        this.view.getUpdateButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CatalogUpdateController.this.updateCatalog();
            }
        });
        this.view.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CatalogUpdateController.this.view.dispose();
            }
        });
    }

    protected void updateCatalog() {
        boolean doAll = this.isAllEntities();
        String defaultCatalog = this.dataMap.getDefaultCatalog();
        for (DbEntity entity : this.dataMap.getDbEntities()) {
            if (!doAll && !Util.isEmptyString((String)entity.getCatalog()) || Util.nullSafeEquals((Object)defaultCatalog, (Object)entity.getCatalog())) continue;
            entity.setCatalog(defaultCatalog);
            this.mediator.fireDbEntityEvent(new EntityEvent((Object)this, (Entity)entity));
        }
        for (Procedure procedure : this.dataMap.getProcedures()) {
            if (!doAll && !Util.isEmptyString((String)procedure.getCatalog()) || Util.nullSafeEquals((Object)defaultCatalog, (Object)procedure.getCatalog())) continue;
            procedure.setCatalog(defaultCatalog);
            this.mediator.fireProcedureEvent(new ProcedureEvent(this, procedure));
        }
        this.view.dispose();
    }
}

