/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.datamap;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.EmbeddableEvent;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.datamap.DefaultsPreferencesController;
import org.apache.cayenne.modeler.dialog.datamap.DefaultsPreferencesView;
import org.apache.cayenne.util.Util;

public class PackageUpdateController
extends DefaultsPreferencesController {
    public static final String ALL_CONTROL = "Set/update package for all ObjEntities and Embeddables (create default class names if missing)";
    public static final String UNINIT_CONTROL = "Do not override class names with packages";
    protected boolean clientUpdate;
    protected DefaultsPreferencesView view;

    public PackageUpdateController(ProjectController mediator, DataMap dataMap, boolean clientUpdate) {
        super(mediator, dataMap);
        this.clientUpdate = clientUpdate;
    }

    public void startupAction() {
        this.view = new DefaultsPreferencesView(ALL_CONTROL, UNINIT_CONTROL);
        this.view.setTitle("Update ObjEntities and Embeddables Java Package");
        this.initController();
        this.view.pack();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
    }

    @Override
    public Component getView() {
        return this.view;
    }

    private void initController() {
        this.view.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PackageUpdateController.this.view.dispose();
            }
        });
        this.view.getUpdateButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PackageUpdateController.this.updatePackage();
            }
        });
    }

    protected void updatePackage() {
        String oldName;
        boolean doAll = this.isAllEntities();
        HashMap<String, String> oldNameEmbeddableToNewName = new HashMap<String, String>();
        for (Embeddable embeddable : this.dataMap.getEmbeddables()) {
            oldName = embeddable.getClassName();
            Pattern p = Pattern.compile("[.]");
            String[] tokens = p.split(oldName);
            String className = tokens[tokens.length - 1];
            if (!doAll && !Util.isEmptyString((String)oldName) && oldName.indexOf(46) >= 0) continue;
            EmbeddableEvent e = new EmbeddableEvent((Object)this, embeddable, embeddable.getClassName());
            String newClassName = this.getNameWithDefaultPackage(className);
            oldNameEmbeddableToNewName.put(oldName, newClassName);
            embeddable.setClassName(newClassName);
            this.mediator.fireEmbeddableEvent(e, this.mediator.getCurrentDataMap());
        }
        for (ObjEntity entity : this.dataMap.getObjEntities()) {
            oldName = this.getClassName(entity);
            if (doAll || Util.isEmptyString((String)oldName) || oldName.indexOf(46) < 0) {
                String className = this.extractClassName(Util.isEmptyString((String)oldName) ? entity.getName() : oldName);
                this.setClassName(entity, this.getNameWithDefaultPackage(className));
            }
            for (ObjAttribute attribute : entity.getAttributes()) {
                if (!(attribute instanceof EmbeddedAttribute) || oldNameEmbeddableToNewName.size() <= 0 || !oldNameEmbeddableToNewName.containsKey(attribute.getType())) continue;
                attribute.setType((String)oldNameEmbeddableToNewName.get(attribute.getType()));
                AttributeEvent ev = new AttributeEvent((Object)this, (Attribute)attribute, (Entity)entity);
                this.mediator.fireObjAttributeEvent(ev);
            }
        }
        this.view.dispose();
    }

    protected String extractClassName(String name) {
        if (name == null) {
            return "";
        }
        int dot = name.lastIndexOf(46);
        return dot < 0 ? name : (dot + 1 < name.length() ? name.substring(dot + 1) : "");
    }

    protected String getNameWithDefaultPackage(String name) {
        if (this.clientUpdate) {
            return this.dataMap.getNameWithDefaultClientPackage(name);
        }
        return this.dataMap.getNameWithDefaultPackage(name);
    }

    protected String getClassName(ObjEntity entity) {
        return this.clientUpdate ? entity.getClientClassName() : entity.getClassName();
    }

    protected void setClassName(ObjEntity entity, String newName) {
        if (!Util.nullSafeEquals((Object)newName, (Object)this.getClassName(entity))) {
            if (this.clientUpdate) {
                entity.setClientClassName(newName);
            } else {
                entity.setClassName(newName);
            }
            this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, (Entity)entity));
        }
    }
}

