/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DbLoader;
import org.apache.cayenne.access.DbLoaderDelegate;
import org.apache.cayenne.access.loader.DbLoaderConfiguration;
import org.apache.cayenne.access.loader.DefaultDbLoaderDelegate;
import org.apache.cayenne.access.loader.filters.EntityFilters;
import org.apache.cayenne.access.loader.filters.FilterFactory;
import org.apache.cayenne.access.loader.filters.FiltersConfig;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.event.DataMapEvent;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.naming.DefaultUniqueNameGenerator;
import org.apache.cayenne.map.naming.NameChecker;
import org.apache.cayenne.map.naming.NameCheckers;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.db.DbLoaderOptionsDialog;
import org.apache.cayenne.modeler.event.DataMapDisplayEvent;
import org.apache.cayenne.modeler.util.LongRunningTask;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.tools.dbimport.config.FiltersConfigBuilder;
import org.apache.cayenne.tools.dbimport.config.ReverseEngineering;
import org.apache.cayenne.util.DeleteRuleUpdater;
import org.apache.cayenne.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DbLoaderHelper {
    private static Log logObj = LogFactory.getLog(DbLoaderHelper.class);
    private static final Collection<String> EXCLUDED_TABLES = Arrays.asList("AUTO_PK_SUPPORT", "auto_pk_support");
    protected boolean stoppingReverseEngineering;
    protected boolean existingMap;
    protected ProjectController mediator;
    protected String dbUserName;
    protected String dbCatalog;
    protected DbLoader loader;
    protected DataMap dataMap;
    protected boolean meaningfulPk;
    protected List<String> schemas;
    protected List<String> catalogs;
    private final EntityFilters.Builder filterBuilder = new EntityFilters.Builder();
    protected String loadStatusNote;
    protected List<ObjEntity> addedObjEntities;

    public DbLoaderHelper(ProjectController mediator, Connection connection, DbAdapter adapter, String dbUserName) {
        this.dbUserName = dbUserName;
        this.mediator = mediator;
        try {
            this.dbCatalog = connection.getCatalog();
        }
        catch (SQLException e) {
            logObj.warn((Object)"Error getting catalog.", (Throwable)e);
        }
        this.loader = new DbLoader(connection, adapter, (DbLoaderDelegate)new LoaderDelegate());
    }

    public void setStoppingReverseEngineering(boolean stopReverseEngineering) {
        this.stoppingReverseEngineering = stopReverseEngineering;
    }

    public boolean isStoppingReverseEngineering() {
        return this.stoppingReverseEngineering;
    }

    public void execute() {
        this.stoppingReverseEngineering = false;
        LoadCatalogsTask loadCatalogsTask = new LoadCatalogsTask(Application.getFrame(), "Loading Catalogs");
        loadCatalogsTask.startAndWait();
        if (this.stoppingReverseEngineering) {
            return;
        }
        LoadSchemasTask loadSchemasTask = new LoadSchemasTask(Application.getFrame(), "Loading Schemas");
        loadSchemasTask.startAndWait();
        if (this.stoppingReverseEngineering) {
            return;
        }
        final DbLoaderOptionsDialog dialog = new DbLoaderOptionsDialog(this.schemas, this.catalogs, this.dbUserName, this.dbCatalog, false);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    dialog.setVisible(true);
                    dialog.dispose();
                }
            });
        }
        catch (Throwable th) {
            this.processException(th, "Error Reengineering Database");
            return;
        }
        if (dialog.getChoice() == 0) {
            return;
        }
        this.filterBuilder.catalog(dialog.getSelectedCatalog());
        this.filterBuilder.schema(dialog.getSelectedSchema());
        this.filterBuilder.includeTables(dialog.getTableNamePattern());
        this.filterBuilder.setProceduresFilters(dialog.isLoadingProcedures() ? FilterFactory.TRUE : FilterFactory.NULL);
        this.filterBuilder.includeProcedures(dialog.getProcedureNamePattern());
        this.meaningfulPk = dialog.isMeaningfulPk();
        this.addedObjEntities = new ArrayList<ObjEntity>();
        this.loader.setNameGenerator(dialog.getNamingStrategy());
        LoadDataMapTask loadDataMapTask = new LoadDataMapTask(Application.getFrame(), "Reengineering DB");
        loadDataMapTask.startAndWait();
    }

    protected void processException(final Throwable th, final String message) {
        logObj.info((Object)"Exception on reverse engineering", Util.unwindException((Throwable)th));
        this.cleanup();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(Application.getFrame(), th.getMessage(), message, 0);
            }
        });
    }

    protected void cleanup() {
        this.loadStatusNote = "Closing connection...";
        try {
            if (this.loader.getConnection() != null) {
                this.loader.getConnection().close();
            }
        }
        catch (SQLException e) {
            logObj.warn((Object)"Error closing connection.", (Throwable)e);
        }
    }

    final class LoadDataMapTask
    extends DbLoaderTask {
        public LoadDataMapTask(JFrame frame, String title) {
            super(frame, title);
        }

        @Override
        protected void execute() {
            DbLoaderHelper.this.loadStatusNote = "Preparing...";
            DbLoaderHelper.this.dataMap = DbLoaderHelper.this.mediator.getCurrentDataMap();
            boolean bl = DbLoaderHelper.this.existingMap = DbLoaderHelper.this.dataMap != null;
            if (!DbLoaderHelper.this.existingMap) {
                DbLoaderHelper.this.dataMap = new DataMap(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.dataMap));
                DbLoaderHelper.this.dataMap.setName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.dataMap, (Object)DbLoaderHelper.this.mediator.getProject().getRootNode()));
                DbLoaderHelper.this.dataMap.setDefaultCatalog(DbLoaderHelper.this.filterBuilder.catalog());
                DbLoaderHelper.this.dataMap.setDefaultSchema(DbLoaderHelper.this.filterBuilder.schema());
            }
            if (this.isCanceled()) {
                return;
            }
            this.importingTables();
            this.importingProcedures();
            DbLoaderHelper.this.cleanup();
            DbLoaderHelper.this.loadStatusNote = "Updating view...";
            if (DbLoaderHelper.this.mediator.getCurrentDataMap() != null) {
                DbLoaderHelper.this.mediator.fireDataMapEvent(new DataMapEvent((Object)Application.getFrame(), DbLoaderHelper.this.dataMap, 1));
                DbLoaderHelper.this.mediator.fireDataMapDisplayEvent(new DataMapDisplayEvent(Application.getFrame(), DbLoaderHelper.this.dataMap, (DataChannelDescriptor)DbLoaderHelper.this.mediator.getProject().getRootNode(), DbLoaderHelper.this.mediator.getCurrentDataNode()));
            } else {
                DataChannelDescriptor currentDomain = (DataChannelDescriptor)DbLoaderHelper.this.mediator.getProject().getRootNode();
                Resource baseResource = currentDomain.getConfigurationSource();
                if (baseResource != null) {
                    Resource dataMapResource = baseResource.getRelativeResource(DbLoaderHelper.this.dataMap.getName());
                    DbLoaderHelper.this.dataMap.setConfigurationSource(dataMapResource);
                }
                DbLoaderHelper.this.mediator.addDataMap(Application.getFrame(), DbLoaderHelper.this.dataMap);
            }
        }

        private void importingProcedures() {
            block3: {
                if (!DbLoaderHelper.this.filterBuilder.proceduresFilters().equals(FilterFactory.NULL)) {
                    return;
                }
                DbLoaderHelper.this.loadStatusNote = "Importing procedures...";
                try {
                    DbLoaderConfiguration configuration = new DbLoaderConfiguration();
                    configuration.setFiltersConfig(new FiltersConfig(new EntityFilters[]{DbLoaderHelper.this.filterBuilder.build()}));
                    DbLoaderHelper.this.loader.loadProcedures(DbLoaderHelper.this.dataMap, new DbLoaderConfiguration());
                }
                catch (Throwable th) {
                    if (this.isCanceled()) break block3;
                    DbLoaderHelper.this.processException(th, "Error Reengineering Database");
                }
            }
        }

        private void importingTables() {
            block3: {
                DbLoaderHelper.this.loadStatusNote = "Importing tables...";
                try {
                    DbLoaderHelper.this.loader.setCreatingMeaningfulPK(DbLoaderHelper.this.meaningfulPk);
                    DbLoaderConfiguration configuration = new DbLoaderConfiguration();
                    configuration.setFiltersConfig(new FiltersConfigBuilder(new ReverseEngineering()).add(DbLoaderHelper.this.filterBuilder.build()).filtersConfig());
                    DbLoaderHelper.this.loader.load(DbLoaderHelper.this.dataMap, configuration);
                    for (ObjEntity addedObjEntity : DbLoaderHelper.this.addedObjEntities) {
                        DeleteRuleUpdater.updateObjEntity((ObjEntity)addedObjEntity);
                    }
                }
                catch (Throwable th) {
                    if (this.isCanceled()) break block3;
                    DbLoaderHelper.this.processException(th, "Error Reengineering Database");
                }
            }
        }
    }

    final class LoadCatalogsTask
    extends DbLoaderTask {
        public LoadCatalogsTask(JFrame frame, String title) {
            super(frame, title);
        }

        @Override
        protected void execute() {
            DbLoaderHelper.this.loadStatusNote = "Loading available catalogs...";
            try {
                DbLoaderHelper.this.catalogs = DbLoaderHelper.this.loader.getCatalogs();
            }
            catch (Throwable th) {
                DbLoaderHelper.this.processException(th, "Error Loading Catalogs");
            }
        }
    }

    final class LoadSchemasTask
    extends DbLoaderTask {
        public LoadSchemasTask(JFrame frame, String title) {
            super(frame, title);
        }

        @Override
        protected void execute() {
            DbLoaderHelper.this.loadStatusNote = "Loading available schemas...";
            try {
                DbLoaderHelper.this.schemas = DbLoaderHelper.this.loader.getSchemas();
            }
            catch (Throwable th) {
                DbLoaderHelper.this.processException(th, "Error Loading Schemas");
            }
        }
    }

    abstract class DbLoaderTask
    extends LongRunningTask {
        public DbLoaderTask(JFrame frame, String title) {
            super(frame, title);
            this.setMinValue(0);
            this.setMaxValue(10);
        }

        @Override
        protected String getCurrentNote() {
            return DbLoaderHelper.this.loadStatusNote;
        }

        @Override
        protected int getCurrentValue() {
            return this.getMinValue();
        }

        @Override
        protected boolean isIndeterminate() {
            return true;
        }

        @Override
        public boolean isCanceled() {
            return DbLoaderHelper.this.isStoppingReverseEngineering();
        }

        @Override
        public void setCanceled(boolean b) {
            if (b) {
                DbLoaderHelper.this.loadStatusNote = "Canceling..";
            }
            DbLoaderHelper.this.setStoppingReverseEngineering(b);
        }
    }

    private final class LoaderDelegate
    extends DefaultDbLoaderDelegate {
        private LoaderDelegate() {
        }

        public void dbEntityAdded(DbEntity entity) {
            this.checkCanceled();
            DbLoaderHelper.this.loadStatusNote = "Importing table '" + entity.getName() + "'...";
            if (EXCLUDED_TABLES.contains(entity.getName()) && entity.getDataMap() != null) {
                entity.getDataMap().removeDbEntity(entity.getName());
            } else if (DbLoaderHelper.this.existingMap) {
                DbLoaderHelper.this.mediator.fireDbEntityEvent(new EntityEvent((Object)this, (Entity)entity, 2));
            }
        }

        public void objEntityAdded(ObjEntity entity) {
            this.checkCanceled();
            DbLoaderHelper.this.loadStatusNote = "Creating ObjEntity '" + entity.getName() + "'...";
            DbLoaderHelper.this.addedObjEntities.add(entity);
            if (DbLoaderHelper.this.existingMap) {
                DbLoaderHelper.this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, (Entity)entity, 2));
            }
        }

        public void dbEntityRemoved(DbEntity entity) {
            this.checkCanceled();
            if (DbLoaderHelper.this.existingMap) {
                DbLoaderHelper.this.mediator.fireDbEntityEvent(new EntityEvent((Object)Application.getFrame(), (Entity)entity, 3));
            }
        }

        public void objEntityRemoved(ObjEntity entity) {
            this.checkCanceled();
            if (DbLoaderHelper.this.existingMap) {
                DbLoaderHelper.this.mediator.fireObjEntityEvent(new EntityEvent((Object)Application.getFrame(), (Entity)entity, 3));
            }
        }

        public boolean dbRelationship(DbEntity entity) {
            this.checkCanceled();
            DbLoaderHelper.this.loadStatusNote = "Load relationships for '" + entity.getName() + "'...";
            return true;
        }

        public boolean dbRelationshipLoaded(DbEntity entity, DbRelationship relationship) {
            this.checkCanceled();
            DbLoaderHelper.this.loadStatusNote = "Load relationship: '" + entity.getName() + "'; '" + relationship.getName() + "'...";
            return true;
        }

        void checkCanceled() {
            if (DbLoaderHelper.this.isStoppingReverseEngineering()) {
                throw new CayenneRuntimeException("Reengineering was canceled.", new Object[0]);
            }
        }
    }
}

