/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.util.CayenneDialog;

public class DbMigrateOptionsDialog
extends CayenneDialog {
    private static final long serialVersionUID = 1L;
    public static final int CANCEL = 0;
    public static final int SELECT = 1;
    protected JLabel schemaLabel;
    protected JComboBox schemaSelector;
    protected JButton selectButton;
    protected JButton cancelButton;
    protected int choice;

    public DbMigrateOptionsDialog(Collection<String> schemas, String dbUserName) {
        super((Frame)Application.getFrame(), "Migrate DB Schema: Select Schema");
        this.init();
        this.initController();
        this.initFromModel(schemas, dbUserName);
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.centerWindow();
    }

    protected void init() {
        this.selectButton = new JButton("Continue");
        this.cancelButton = new JButton("Cancel");
        this.schemaSelector = new JComboBox();
        FormLayout layout = new FormLayout("right:pref, 3dlu, fill:max(170dlu;pref):grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        this.schemaLabel = builder.append("Select Schema:", (Component)this.schemaSelector);
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(this.selectButton);
        buttons.add(this.cancelButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        this.getContentPane().add((Component)buttons, "South");
    }

    protected void initController() {
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DbMigrateOptionsDialog.this.processSelect();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DbMigrateOptionsDialog.this.processCancel();
            }
        });
    }

    private void processSelect() {
        this.choice = 1;
        this.setVisible(false);
    }

    private void processCancel() {
        this.schemaSelector.setSelectedItem(null);
        this.choice = 0;
        this.setVisible(false);
    }

    protected void initFromModel(Collection<String> schemas, String dbUserName) {
        this.choice = 0;
        this.schemaSelector.setVisible(true);
        this.schemaLabel.setVisible(true);
        this.schemaSelector.setModel(new DefaultComboBoxModel<String>(schemas.toArray(new String[0])));
        if (dbUserName != null) {
            for (String schema : schemas) {
                if (!dbUserName.equalsIgnoreCase(schema)) continue;
                this.schemaSelector.setSelectedItem(schema);
                break;
            }
        }
    }

    public String getSelectedSchema() {
        return (String)this.schemaSelector.getSelectedItem();
    }

    public int getChoice() {
        return this.choice;
    }

    public void showDialog() {
        this.setVisible(true);
    }
}

