/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.cayenne.merge.MergeDirection;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.dialog.db.MergerTokenSelectorView;
import org.apache.cayenne.modeler.dialog.db.MergerTokenTableModel;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.ObjectBinding;

public class MergerTokenSelectorController
extends CayenneController {
    protected MergerTokenSelectorView view = new MergerTokenSelectorView();
    protected ObjectBinding tableBinding;
    protected MergerToken token;
    protected int permanentlyExcludedCount;
    protected Set<MergerToken> excludedTokens = new HashSet<MergerToken>();
    protected List<MergerToken> selectableTokensList = new ArrayList<MergerToken>();
    protected MergerFactory mergerFactory;

    public MergerTokenSelectorController(CayenneController parent) {
        super(parent);
        this.initController();
    }

    public void setMergerFactory(MergerFactory mergerFactory) {
        this.mergerFactory = mergerFactory;
    }

    public void setTokens(List<MergerToken> tokens) {
        this.selectableTokensList.clear();
        this.selectableTokensList.addAll(tokens);
        this.excludedTokens.addAll(tokens);
    }

    public List<MergerToken> getSelectedTokens() {
        ArrayList<MergerToken> t = new ArrayList<MergerToken>(this.selectableTokensList);
        t.removeAll(this.excludedTokens);
        return Collections.unmodifiableList(t);
    }

    public List<MergerToken> getSelectableTokens() {
        return Collections.unmodifiableList(this.selectableTokensList);
    }

    public void removeToken(MergerToken token) {
        this.selectableTokensList.remove(token);
        this.excludedTokens.remove(token);
        AbstractTableModel model = (AbstractTableModel)this.view.getTokens().getModel();
        model.fireTableDataChanged();
    }

    @Override
    public Component getView() {
        return this.view;
    }

    public void setToken(MergerToken token) {
        this.token = token;
    }

    public boolean isIncluded() {
        if (this.token == null) {
            return false;
        }
        return !this.excludedTokens.contains(this.token);
    }

    public void setIncluded(boolean b) {
        if (this.token == null) {
            return;
        }
        if (b) {
            this.excludedTokens.remove(this.token);
        } else {
            this.excludedTokens.add(this.token);
        }
        this.tableSelectedAction();
    }

    public void tableSelectedAction() {
        int unselectedCount = this.excludedTokens.size() - this.permanentlyExcludedCount;
        if (unselectedCount == this.selectableTokensList.size()) {
            this.view.getCheckAll().setSelected(false);
        } else if (unselectedCount == 0) {
            this.view.getCheckAll().setSelected(true);
        }
    }

    protected void initController() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getCheckAll(), "checkAllAction()");
        builder.bindToAction(this.view.getReverseAll(), "reverseAllAction()");
        MergerTokenTableModel model = new MergerTokenTableModel(this);
        Object[] dirs = new MergeDirection[]{MergeDirection.TO_DB, MergeDirection.TO_MODEL};
        this.view.getTokens().setModel(model);
        TableColumnModel columnModel = this.view.getTokens().getColumnModel();
        JComboBox directionCombo = Application.getWidgetFactory().createComboBox(dirs, false);
        directionCombo.setEditable(false);
        TableColumn directionColumn = columnModel.getColumn(1);
        directionColumn.setCellEditor(new DefaultCellEditor(directionCombo));
        columnModel.getColumn(0).setPreferredWidth(50);
        columnModel.getColumn(1).setPreferredWidth(100);
        columnModel.getColumn(0).setMaxWidth(50);
        columnModel.getColumn(1).setMaxWidth(100);
    }

    public boolean isSelected(MergerToken token) {
        return this.selectableTokensList.contains(token) && !this.excludedTokens.contains(token);
    }

    public void select(MergerToken token, boolean select) {
        if (select) {
            this.excludedTokens.remove(token);
        } else {
            this.excludedTokens.add(token);
        }
    }

    public void setDirection(MergerToken token, MergeDirection direction) {
        if (token.getDirection().equals((Object)direction)) {
            return;
        }
        int i = this.selectableTokensList.indexOf(token);
        MergerToken reverse = token.createReverse(this.mergerFactory);
        this.selectableTokensList.set(i, reverse);
        if (this.excludedTokens.remove(token)) {
            this.excludedTokens.add(reverse);
        }
        this.view.getTokens().repaint();
    }

    public void checkAllAction() {
        boolean isCheckAllSelected = this.view.getCheckAll().isSelected();
        if (isCheckAllSelected) {
            this.excludedTokens.clear();
        } else {
            this.excludedTokens.addAll(this.selectableTokensList);
        }
        AbstractTableModel model = (AbstractTableModel)this.view.getTokens().getModel();
        model.fireTableDataChanged();
    }

    public void reverseAllAction() {
        for (int i = 0; i < this.selectableTokensList.size(); ++i) {
            MergerToken token = this.selectableTokensList.get(i);
            MergerToken reverse = token.createReverse(this.mergerFactory);
            this.selectableTokensList.set(i, reverse);
            if (!this.excludedTokens.remove(token)) continue;
            this.excludedTokens.add(reverse);
        }
        AbstractTableModel model = (AbstractTableModel)this.view.getTokens().getModel();
        model.fireTableDataChanged();
    }
}

