/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.db.TableSelectorView;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.validation.ProjectValidator;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.ObjectBinding;
import org.apache.cayenne.swing.TableBindingBuilder;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;

public class TableSelectorController
extends CayenneController {
    protected TableSelectorView view = new TableSelectorView();
    protected ObjectBinding tableBinding;
    protected DbEntity table;
    protected List<DbEntity> tables;
    protected int permanentlyExcludedCount;
    protected Map<String, DbEntity> excludedTables = new HashMap<String, DbEntity>();
    protected List<DbEntity> selectableTablesList = new ArrayList<DbEntity>();
    protected Map<String, String> validationMessages = new HashMap<String, String>();

    public TableSelectorController(ProjectController parent) {
        super(parent);
        this.initController();
    }

    @Override
    public Component getView() {
        return this.view;
    }

    public void setTable(DbEntity table) {
        this.table = table;
    }

    public Collection<DbEntity> getExcludedTables() {
        return this.excludedTables.values();
    }

    public List<DbEntity> getTables() {
        return this.tables;
    }

    public boolean isIncluded() {
        if (this.table == null) {
            return false;
        }
        return !this.excludedTables.containsKey(this.table.getName());
    }

    public void setIncluded(boolean b) {
        if (this.table == null) {
            return;
        }
        if (b) {
            this.excludedTables.remove(this.table.getName());
        } else {
            this.excludedTables.put(this.table.getName(), this.table);
        }
        this.tableSelectedAction();
    }

    public void tableSelectedAction() {
        int unselectedCount = this.excludedTables.size() - this.permanentlyExcludedCount;
        if (unselectedCount == this.selectableTablesList.size()) {
            this.view.getCheckAll().setSelected(false);
        } else if (unselectedCount == 0) {
            this.view.getCheckAll().setSelected(true);
        }
    }

    public Object getProblem() {
        return this.table != null ? this.validationMessages.get(this.table.getName()) : null;
    }

    protected void initController() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getCheckAll(), "checkAllAction()");
        TableBindingBuilder tableBuilder = new TableBindingBuilder(builder);
        tableBuilder.addColumn("", "setTable(#item), included", Boolean.class, true, Boolean.TRUE);
        tableBuilder.addColumn("Table", "#item.name", String.class, false, "XXXXXXXXXXXXXXXX");
        tableBuilder.addColumn("Problems", "setTable(#item), problem", String.class, false, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.tableBinding = tableBuilder.bindToTable(this.view.getTables(), "tables");
    }

    public void updateTables(Collection<DataMap> dataMaps) {
        this.tables = new ArrayList<DbEntity>();
        for (DataMap dataMap : dataMaps) {
            this.tables.addAll(dataMap.getDbEntities());
        }
        this.excludedTables.clear();
        this.validationMessages.clear();
        Project project = this.getApplication().getProject();
        ProjectValidator projectValidator = (ProjectValidator)this.getApplication().getInjector().getInstance(ProjectValidator.class);
        ValidationResult validationResult = projectValidator.validate(project.getRootNode());
        if (validationResult.getFailures().size() > 0) {
            for (ValidationFailure nextProblem : validationResult.getFailures()) {
                DbEntity failedEntity = null;
                if (nextProblem.getSource() instanceof DbAttribute) {
                    DbAttribute failedAttribute = (DbAttribute)nextProblem.getSource();
                    failedEntity = failedAttribute.getEntity();
                } else if (nextProblem.getSource() instanceof DbRelationship) {
                    DbRelationship failedRelationship = (DbRelationship)nextProblem.getSource();
                    failedEntity = failedRelationship.getSourceEntity();
                } else if (nextProblem.getSource() instanceof DbEntity) {
                    failedEntity = (DbEntity)nextProblem.getSource();
                }
                if (failedEntity == null) continue;
                this.excludedTables.put(failedEntity.getName(), failedEntity);
                this.validationMessages.put(failedEntity.getName(), nextProblem.getDescription());
            }
        }
        this.permanentlyExcludedCount = this.excludedTables.size();
        this.selectableTablesList.clear();
        for (DbEntity table : this.tables) {
            if (this.excludedTables.containsKey(table.getName())) continue;
            this.selectableTablesList.add(table);
        }
        this.tableBinding.updateView();
        this.tableSelectedAction();
    }

    public void checkAllAction() {
        boolean isCheckAllSelected = this.view.getCheckAll().isSelected();
        if (isCheckAllSelected) {
            this.selectableTablesList.clear();
            this.selectableTablesList.addAll(this.tables);
            this.excludedTables.clear();
        } else {
            this.excludedTables.clear();
            for (DbEntity table : this.tables) {
                this.excludedTables.put(table.getName(), table);
            }
            this.selectableTablesList.clear();
        }
        this.tableBinding.updateView();
    }
}

