/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.naming.ObjectNameGenerator;
import org.apache.cayenne.modeler.dialog.objentity.EntitySyncDialog;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.NameGeneratorPreferences;
import org.apache.cayenne.util.EntityMergeSupport;

public class EntitySyncController
extends CayenneController {
    private final DbEntity dbEntity;
    private ObjEntity objEntity;
    private EntitySyncDialog view;

    public EntitySyncController(CayenneController parent, DbEntity dbEntity) {
        super(parent);
        this.dbEntity = dbEntity;
    }

    public EntitySyncController(CayenneController parent, ObjEntity objEntity) {
        this(parent, objEntity.getDbEntity());
        this.objEntity = objEntity;
    }

    public EntityMergeSupport createMerger() {
        ObjectNameGenerator namingStrategy;
        Collection<ObjEntity> entities = this.getObjEntities();
        if (entities.isEmpty()) {
            return null;
        }
        try {
            namingStrategy = NameGeneratorPreferences.getInstance().createNamingStrategy(this.application);
        }
        catch (Throwable e) {
            namingStrategy = NameGeneratorPreferences.defaultNameGenerator();
        }
        EntityMergeSupport merger = new EntityMergeSupport(this.dbEntity.getDataMap(), namingStrategy, true);
        for (ObjEntity entity : entities) {
            if (merger.getMeaningfulFKs(entity).isEmpty()) continue;
            return this.configureMerger(merger);
        }
        return merger;
    }

    protected EntityMergeSupport configureMerger(final EntityMergeSupport merger) {
        final boolean[] cancel = new boolean[1];
        this.view = new EntitySyncDialog();
        this.view.getUpdateButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                merger.setRemoveMeaningfulFKs(EntitySyncController.this.view.getRemoveFKs().isSelected());
                EntitySyncController.this.view.dispose();
            }
        });
        this.view.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cancel[0] = true;
                EntitySyncController.this.view.dispose();
            }
        });
        this.view.pack();
        this.view.setModal(true);
        this.centerView();
        this.makeCloseableOnEscape();
        this.view.setVisible(true);
        return cancel[0] ? null : merger;
    }

    @Override
    public Component getView() {
        return this.view;
    }

    protected Collection<ObjEntity> getObjEntities() {
        return this.objEntity == null ? this.dbEntity.getDataMap().getMappedEntities(this.dbEntity) : Collections.singleton(this.objEntity);
    }
}

