/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.pref;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import org.apache.cayenne.modeler.dialog.pref.ClasspathPreferencesView;
import org.apache.cayenne.modeler.dialog.pref.PreferenceDialog;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.FileFilters;
import org.apache.cayenne.pref.CayennePreferenceEditor;
import org.apache.cayenne.pref.PreferenceEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClasspathPreferences
extends CayenneController {
    private static final Log logger = LogFactory.getLog(ClasspathPreferences.class);
    protected ClasspathPreferencesView view = new ClasspathPreferencesView();
    protected List<String> classPathEntries;
    protected ClasspathTableModel tableModel;
    protected CayennePreferenceEditor editor;
    protected List<String> classPathKeys;
    private Preferences preferences = this.getApplication().getPreferencesNode(this.getClass(), "");
    private int counter;

    public ClasspathPreferences(PreferenceDialog parentController) {
        super(parentController);
        PreferenceEditor editor = parentController.getEditor();
        if (editor instanceof CayennePreferenceEditor) {
            this.editor = (CayennePreferenceEditor)editor;
        }
        ArrayList<String> classPathEntries = new ArrayList<String>();
        ArrayList<String> classPathKeys = new ArrayList<String>();
        this.counter = this.loadPreferences(classPathEntries, classPathKeys);
        this.classPathEntries = classPathEntries;
        this.classPathKeys = classPathKeys;
        this.tableModel = new ClasspathTableModel();
        this.initBindings();
    }

    private int loadPreferences(List<String> classPathEntries, List<String> classPathKeys) {
        String[] cpKeys;
        try {
            cpKeys = this.preferences.keys();
        }
        catch (BackingStoreException e) {
            logger.info((Object)"Error loading preferences", (Throwable)e);
            return 0;
        }
        int max = 0;
        for (String cpKey : cpKeys) {
            String tempValue;
            int c;
            try {
                c = Integer.parseInt(cpKey);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (c > max) {
                max = c;
            }
            if ("".equals(tempValue = this.preferences.get(cpKey, ""))) continue;
            classPathEntries.add(tempValue);
            classPathKeys.add(cpKey);
        }
        return max;
    }

    @Override
    public Component getView() {
        return this.view;
    }

    protected void initBindings() {
        this.view.getTable().setModel(this.tableModel);
        this.view.getAddDirButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClasspathPreferences.this.addClassDirectoryAction();
            }
        });
        this.view.getRemoveEntryButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClasspathPreferences.this.removeEntryAction();
            }
        });
        this.view.getAddJarButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClasspathPreferences.this.addJarOrZipAction();
            }
        });
    }

    protected void addJarOrZipAction() {
        this.chooseClassEntry(FileFilters.getClassArchiveFilter(), "Select JAR or ZIP File.", 0);
    }

    protected void addClassDirectoryAction() {
        this.chooseClassEntry(null, "Select Java Class Directory.", 1);
    }

    protected void removeEntryAction() {
        int selected = this.view.getTable().getSelectedRow();
        if (selected < 0) {
            return;
        }
        this.addRemovedPreferences(this.classPathKeys.get(selected));
        this.classPathEntries.remove(selected);
        this.classPathKeys.remove(selected);
        this.tableModel.fireTableRowsDeleted(selected, selected);
    }

    protected void chooseClassEntry(FileFilter filter, String title, int selectionMode) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(selectionMode);
        chooser.setDialogType(0);
        chooser.setAcceptAllFileFilterUsed(true);
        this.getLastDirectory().updateChooser(chooser);
        if (filter != null) {
            chooser.addChoosableFileFilter(filter);
        }
        chooser.setDialogTitle(title);
        File selected = null;
        int result = chooser.showOpenDialog(this.view);
        if (result == 0) {
            selected = chooser.getSelectedFile();
        }
        if (selected != null && !this.classPathEntries.contains(selected.getAbsolutePath())) {
            this.getLastDirectory().updateFromChooser(chooser);
            int len = this.classPathEntries.size();
            int key = ++this.counter;
            String value = selected.getAbsolutePath();
            this.addChangedPreferences(Integer.toString(key), value);
            this.classPathEntries.add(value);
            this.classPathKeys.add(Integer.toString(key));
            this.tableModel.fireTableRowsInserted(len, len);
        }
    }

    public void addChangedPreferences(String key, String value) {
        Map<String, String> map = this.editor.getChangedPreferences().get(this.preferences);
        if (map == null) {
            map = new HashMap<String, String>();
        }
        map.put(key, value);
        this.editor.getChangedPreferences().put(this.preferences, map);
    }

    public void addRemovedPreferences(String key) {
        Map<String, String> map = this.editor.getRemovedPreferences().get(this.preferences);
        if (map == null) {
            map = new HashMap<String, String>();
        }
        map.put(key, "");
        this.editor.getRemovedPreferences().put(this.preferences, map);
    }

    class ClasspathTableModel
    extends AbstractTableModel {
        ClasspathTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ClasspathPreferences.this.classPathEntries.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return ClasspathPreferences.this.classPathEntries.get(rowIndex);
        }

        @Override
        public String getColumnName(int column) {
            return "Custom ClassPath";
        }
    }
}

