/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.pref;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import org.apache.cayenne.modeler.dialog.pref.EncodingSelector;
import org.apache.cayenne.modeler.dialog.pref.GeneralPreferencesView;
import org.apache.cayenne.modeler.dialog.pref.PreferenceDialog;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.pref.CayennePreferenceEditor;
import org.apache.cayenne.pref.PreferenceEditor;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.ObjectBinding;

public class GeneralPreferences
extends CayenneController {
    public static final String AUTO_LOAD_PROJECT_PREFERENCE = "autoLoadProject";
    public static final String DELETE_PROMPT_PREFERENCE = "deletePrompt";
    public static final String ENCODING_PREFERENCE = "encoding";
    protected GeneralPreferencesView view = new GeneralPreferencesView();
    protected CayennePreferenceEditor editor;
    protected boolean autoLoadProjectPreference;
    protected String encoding;
    protected boolean deletePromptPreference;
    protected Preferences preferences;
    protected ObjectBinding encodingBinding;
    protected ObjectBinding autoLoadProjectBinding;
    protected ObjectBinding deletePromptBinding;

    public GeneralPreferences(PreferenceDialog parentController) {
        super(parentController);
        PreferenceEditor editor = parentController.getEditor();
        if (editor instanceof CayennePreferenceEditor) {
            this.editor = (CayennePreferenceEditor)editor;
            this.view.setEnabled(true);
            this.initBindings();
            this.encodingBinding.updateView();
            this.autoLoadProjectBinding.updateView();
            this.deletePromptBinding.updateView();
        } else {
            this.view.setEnabled(false);
        }
    }

    @Override
    public Component getView() {
        return this.view;
    }

    protected void initBindings() {
        this.preferences = this.application.getPreferencesNode(GeneralPreferences.class, "");
        this.encoding = this.preferences.get(ENCODING_PREFERENCE, null);
        this.autoLoadProjectPreference = this.preferences.getBoolean(AUTO_LOAD_PROJECT_PREFERENCE, false);
        this.deletePromptPreference = this.preferences.getBoolean(DELETE_PROMPT_PREFERENCE, false);
        EncodingSelector encodingSelector = new EncodingSelector(this, this.view.getEncodingSelector());
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        this.encodingBinding = builder.bindToProperty(encodingSelector, ENCODING_PREFERENCE, ENCODING_PREFERENCE);
        this.autoLoadProjectBinding = builder.bindToCheckBox(this.view.getAutoLoadProject(), AUTO_LOAD_PROJECT_PREFERENCE);
        this.deletePromptBinding = builder.bindToCheckBox(this.view.getDeletePrompt(), DELETE_PROMPT_PREFERENCE);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.addChangedPreferences(ENCODING_PREFERENCE, encoding);
        this.encoding = encoding;
    }

    public boolean getAutoLoadProject() {
        return this.autoLoadProjectPreference;
    }

    public void setAutoLoadProject(boolean autoLoadProject) {
        this.addChangedBooleanPreferences(AUTO_LOAD_PROJECT_PREFERENCE, autoLoadProject);
        this.autoLoadProjectPreference = autoLoadProject;
    }

    public boolean getDeletePrompt() {
        return this.deletePromptPreference;
    }

    public void setDeletePrompt(boolean deletePrompt) {
        this.addChangedBooleanPreferences(DELETE_PROMPT_PREFERENCE, deletePrompt);
        this.deletePromptPreference = deletePrompt;
    }

    public void addChangedBooleanPreferences(String key, boolean value) {
        Map<String, Boolean> map = this.editor.getChangedBooleanPreferences().get(this.preferences);
        if (map == null) {
            map = new HashMap<String, Boolean>();
        }
        map.put(key, value);
        this.editor.getChangedBooleanPreferences().put(this.preferences, map);
    }

    public void addChangedPreferences(String key, String value) {
        Map<String, String> map = this.editor.getChangedPreferences().get(this.preferences);
        if (map == null) {
            map = new HashMap<String, String>();
        }
        map.put(key, value);
        this.editor.getChangedPreferences().put(this.preferences, map);
    }
}

