/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.event.DomainEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.datadomain.CacheSyncConfigController;
import org.apache.cayenne.modeler.event.DomainDisplayEvent;
import org.apache.cayenne.modeler.event.DomainDisplayListener;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.pref.RenamedPreferences;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;

public class DataDomainView
extends JPanel
implements DomainDisplayListener {
    protected ProjectController projectController;
    protected TextAdapter name;
    protected TextAdapter cacheSize;
    protected JCheckBox objectValidation;
    protected JCheckBox sharedCache;
    protected JCheckBox remoteUpdates;
    protected JButton configRemoteUpdates;

    public DataDomainView(ProjectController projectController) {
        this.projectController = projectController;
        this.initView();
        this.initController();
    }

    protected void initView() {
        this.name = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                DataDomainView.this.setDomainName(text);
            }
        };
        this.cacheSize = new TextAdapter(new JTextField(10)){

            @Override
            protected void updateModel(String text) {
                DataDomainView.this.setCacheSize(text);
            }
        };
        this.objectValidation = new JCheckBox();
        this.sharedCache = new JCheckBox();
        this.remoteUpdates = new JCheckBox();
        this.configRemoteUpdates = new JButton("Configure...");
        this.configRemoteUpdates.setEnabled(false);
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("right:pref, 3dlu, fill:50dlu, 3dlu, fill:47dlu, 3dlu, fill:100", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.addSeparator("DataDomain Configuration", cc.xywh(1, 1, 7, 1));
        builder.addLabel("DataDomain Name:", cc.xy(1, 3));
        builder.add((Component)this.name.getComponent(), cc.xywh(3, 3, 5, 1));
        builder.addLabel("Object Validation:", cc.xy(1, 5));
        builder.add((Component)this.objectValidation, cc.xy(3, 5));
        builder.addSeparator("Cache Configuration", cc.xywh(1, 7, 7, 1));
        builder.addLabel("Size of Object Cache:", cc.xy(1, 9));
        builder.add((Component)this.cacheSize.getComponent(), cc.xy(3, 9));
        builder.addLabel("Use Shared Cache:", cc.xy(1, 11));
        builder.add((Component)this.sharedCache, cc.xy(3, 11));
        builder.addLabel("Remote Change Notifications:", cc.xy(1, 13));
        builder.add((Component)this.remoteUpdates, cc.xy(3, 13));
        builder.add((Component)this.configRemoteUpdates, cc.xy(7, 13));
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "Center");
    }

    protected void initController() {
        this.projectController.addDomainDisplayListener(this);
        this.objectValidation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String value = DataDomainView.this.objectValidation.isSelected() ? "true" : "false";
                DataDomainView.this.setDomainProperty("cayenne.DataDomain.validatingObjectsOnCommit", value, Boolean.toString(true));
            }
        });
        this.sharedCache.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String value = DataDomainView.this.sharedCache.isSelected() ? "true" : "false";
                DataDomainView.this.setDomainProperty("cayenne.DataDomain.sharedCache", value, Boolean.toString(true));
                DataDomainView.this.remoteUpdates.setEnabled(DataDomainView.this.sharedCache.isSelected());
                if (!DataDomainView.this.sharedCache.isSelected()) {
                    DataDomainView.this.remoteUpdates.setSelected(false);
                    DataDomainView.this.setDomainProperty("cayenne.DataRowStore.remote.notify", "false", Boolean.toString(false));
                }
                DataDomainView.this.configRemoteUpdates.setEnabled(DataDomainView.this.remoteUpdates.isSelected());
            }
        });
        this.remoteUpdates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String value = DataDomainView.this.remoteUpdates.isSelected() ? "true" : "false";
                DataDomainView.this.configRemoteUpdates.setEnabled(DataDomainView.this.remoteUpdates.isSelected());
                DataDomainView.this.setDomainProperty("cayenne.DataRowStore.remote.notify", value, Boolean.toString(false));
            }
        });
        this.configRemoteUpdates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new CacheSyncConfigController(DataDomainView.this.projectController).startup();
            }
        });
    }

    protected void setDomainProperty(String property, String value, String defaultValue) {
        Map properties;
        Object oldValue;
        DataChannelDescriptor domain = (DataChannelDescriptor)this.projectController.getProject().getRootNode();
        if (domain == null) {
            return;
        }
        if ("".equals(value)) {
            value = null;
        }
        if (value != null && value.equals(defaultValue)) {
            value = null;
        }
        if (!Util.nullSafeEquals((Object)value, oldValue = (properties = domain.getProperties()).get(property))) {
            properties.put(property, value);
            DomainEvent e = new DomainEvent(this, domain);
            this.projectController.fireDomainEvent(e);
        }
    }

    public String getDomainProperty(String property, String defaultValue) {
        DataChannelDescriptor domain = (DataChannelDescriptor)this.projectController.getProject().getRootNode();
        if (domain == null) {
            return null;
        }
        String value = (String)domain.getProperties().get(property);
        return value != null ? value : defaultValue;
    }

    public boolean getDomainBooleanProperty(String property, String defaultValue) {
        return "true".equalsIgnoreCase(this.getDomainProperty(property, defaultValue));
    }

    @Override
    public void currentDomainChanged(DomainDisplayEvent e) {
        DataChannelDescriptor domain = e.getDomain();
        if (null == domain) {
            return;
        }
        this.name.setText(domain.getName());
        this.cacheSize.setText(this.getDomainProperty("cayenne.DataRowStore.snapshot.size", Integer.toString(10000)));
        this.objectValidation.setSelected(this.getDomainBooleanProperty("cayenne.DataDomain.validatingObjectsOnCommit", Boolean.toString(true)));
        this.sharedCache.setSelected(this.getDomainBooleanProperty("cayenne.DataDomain.sharedCache", Boolean.toString(true)));
        this.remoteUpdates.setSelected(this.getDomainBooleanProperty("cayenne.DataRowStore.remote.notify", Boolean.toString(false)));
        this.remoteUpdates.setEnabled(this.sharedCache.isSelected());
        this.configRemoteUpdates.setEnabled(this.remoteUpdates.isEnabled() && this.remoteUpdates.isSelected());
    }

    void setDomainName(String newName) {
        DataChannelDescriptor dataChannelDescriptor = (DataChannelDescriptor)Application.getInstance().getProject().getRootNode();
        if (Util.nullSafeEquals((Object)dataChannelDescriptor.getName(), (Object)newName)) {
            return;
        }
        if (newName == null || newName.trim().length() == 0) {
            throw new ValidationException("Enter name for DataDomain", new Object[0]);
        }
        Preferences prefs = this.projectController.getPreferenceForDataDomain();
        DomainEvent e = new DomainEvent((Object)this, dataChannelDescriptor, dataChannelDescriptor.getName());
        dataChannelDescriptor.setName(newName);
        RenamedPreferences.copyPreferences(newName, prefs);
        this.projectController.fireDomainEvent(e);
    }

    void setCacheSize(String text) {
        if (text.length() > 0) {
            try {
                Integer.parseInt(text);
            }
            catch (NumberFormatException ex) {
                throw new ValidationException("Cache size must be an integer: " + text, new Object[0]);
            }
        }
        this.setDomainProperty("cayenne.DataRowStore.snapshot.size", text, Integer.toString(10000));
    }
}

