/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.ProjectTreeView;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.CollapseTreeAction;
import org.apache.cayenne.modeler.action.FilterAction;
import org.apache.cayenne.modeler.dialog.datadomain.FilterController;
import org.apache.cayenne.modeler.editor.DataDomainTabbedView;
import org.apache.cayenne.modeler.editor.DataMapTabbedView;
import org.apache.cayenne.modeler.editor.EjbqlTabbedView;
import org.apache.cayenne.modeler.editor.EmbeddableTabbedView;
import org.apache.cayenne.modeler.editor.ObjEntityTabbedView;
import org.apache.cayenne.modeler.editor.ProcedureQueryView;
import org.apache.cayenne.modeler.editor.ProcedureTabbedView;
import org.apache.cayenne.modeler.editor.SQLTemplateTabbedView;
import org.apache.cayenne.modeler.editor.SelectQueryTabbedView;
import org.apache.cayenne.modeler.editor.datanode.DataNodeEditor;
import org.apache.cayenne.modeler.editor.dbentity.DbEntityTabbedView;
import org.apache.cayenne.modeler.event.DataMapDisplayEvent;
import org.apache.cayenne.modeler.event.DataMapDisplayListener;
import org.apache.cayenne.modeler.event.DataNodeDisplayEvent;
import org.apache.cayenne.modeler.event.DataNodeDisplayListener;
import org.apache.cayenne.modeler.event.DbEntityDisplayListener;
import org.apache.cayenne.modeler.event.DomainDisplayEvent;
import org.apache.cayenne.modeler.event.DomainDisplayListener;
import org.apache.cayenne.modeler.event.EmbeddableDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableDisplayListener;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.MultipleObjectsDisplayEvent;
import org.apache.cayenne.modeler.event.MultipleObjectsDisplayListener;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.event.ProcedureDisplayEvent;
import org.apache.cayenne.modeler.event.ProcedureDisplayListener;
import org.apache.cayenne.modeler.event.QueryDisplayEvent;
import org.apache.cayenne.modeler.event.QueryDisplayListener;
import org.apache.cayenne.modeler.pref.ComponentGeometry;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.commons.logging.LogFactory;

public class EditorView
extends JPanel
implements ObjEntityDisplayListener,
DbEntityDisplayListener,
DomainDisplayListener,
DataMapDisplayListener,
DataNodeDisplayListener,
ProcedureDisplayListener,
QueryDisplayListener,
MultipleObjectsDisplayListener,
EmbeddableDisplayListener {
    private static final String EMPTY_VIEW = "Empty";
    private static final String DOMAIN_VIEW = "Domain";
    private static final String NODE_VIEW = "Node";
    private static final String DATA_MAP_VIEW = "DataMap";
    private static final String OBJ_VIEW = "ObjView";
    private static final String DB_VIEW = "DbView";
    private static final String EMBEDDABLE_VIEW = "EmbeddableView";
    private static final String PROCEDURE_VIEW = "ProcedureView";
    private static final String SELECT_QUERY_VIEW = "SelectQueryView";
    private static final String SQL_TEMPLATE_VIEW = "SQLTemplateView";
    private static final String PROCEDURE_QUERY_VIEW = "ProcedureQueryView";
    private static final String EJBQL_QUERY_VIEW = "EjbqlQueryView";
    protected ProjectController eventController;
    protected JSplitPane splitPane;
    protected JPanel leftPanel;
    protected Container detailPanel;
    protected CardLayout detailLayout;
    private ProjectTreeView treePanel;
    private DbEntityTabbedView dbDetailView;
    private ObjEntityTabbedView objDetailView;
    private EmbeddableTabbedView embeddableView;
    private DataDomainTabbedView dataDomainView;
    private DataMapTabbedView dataMapView;
    private ProcedureTabbedView procedureView;
    private SelectQueryTabbedView selectQueryView;
    private SQLTemplateTabbedView sqlTemplateView;
    private EjbqlTabbedView ejbqlQueryView;
    private JTabbedPane dataNodeView;
    protected ActionManager actionManager;
    private FilterController filterController;

    public FilterController getFilterController() {
        return this.filterController;
    }

    public SelectQueryTabbedView getSelectQueryView() {
        return this.selectQueryView;
    }

    public SQLTemplateTabbedView getSqlTemplateView() {
        return this.sqlTemplateView;
    }

    public EjbqlTabbedView getEjbqlQueryView() {
        return this.ejbqlQueryView;
    }

    public ProcedureTabbedView getProcedureView() {
        return this.procedureView;
    }

    public ProjectTreeView getProjectTreeView() {
        return this.treePanel;
    }

    public EmbeddableTabbedView getEmbeddableView() {
        return this.embeddableView;
    }

    public DbEntityTabbedView getDbDetailView() {
        return this.dbDetailView;
    }

    public ObjEntityTabbedView getObjDetailView() {
        return this.objDetailView;
    }

    public DataDomainTabbedView getDataDomainView() {
        return this.dataDomainView;
    }

    public DataMapTabbedView getDataMapView() {
        return this.dataMapView;
    }

    public JTabbedPane getDataNodeView() {
        return this.dataNodeView;
    }

    public ProjectTreeView getTreePanel() {
        return this.treePanel;
    }

    public EditorView(ProjectController eventController) {
        this.eventController = eventController;
        this.actionManager = eventController.getApplication().getActionManager();
        this.initView();
        this.initController();
    }

    public ProjectController getEventController() {
        return this.eventController;
    }

    private void initView() {
        JButton collapseButton = this.getAction(CollapseTreeAction.class).buildButton();
        collapseButton.setPreferredSize(new Dimension(35, 30));
        JButton filterButton = this.getAction(FilterAction.class).buildButton();
        filterButton.setPreferredSize(new Dimension(35, 30));
        this.actionManager.getAction(CollapseTreeAction.class).setAlwaysOn(true);
        this.actionManager.getAction(FilterAction.class).setAlwaysOn(true);
        JPanel barPanel = new JPanel(true);
        barPanel.setMinimumSize(new Dimension(75, 33));
        barPanel.setLayout(new FlowLayout(4, 1, 0));
        barPanel.add(collapseButton);
        barPanel.add(filterButton);
        barPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.treePanel = new ProjectTreeView(this.eventController);
        this.treePanel.setMinimumSize(new Dimension(75, 180));
        JPanel treeNavigatePanel = new JPanel();
        treeNavigatePanel.setMinimumSize(new Dimension(75, 220));
        treeNavigatePanel.setLayout(new BorderLayout());
        treeNavigatePanel.add((Component)this.treePanel, "Center");
        this.detailPanel = new JPanel();
        this.splitPane = new JSplitPane(1, true);
        this.leftPanel = new JPanel(new BorderLayout());
        this.detailLayout = new CardLayout();
        this.detailPanel.setLayout(this.detailLayout);
        this.detailPanel.add((Component)new JPanel(), EMPTY_VIEW);
        this.dataDomainView = new DataDomainTabbedView(this.eventController);
        this.detailPanel.add((Component)this.dataDomainView, DOMAIN_VIEW);
        DataNodeEditor nodeController = new DataNodeEditor(this.eventController);
        this.detailPanel.add(nodeController.getView(), NODE_VIEW);
        this.dataNodeView = nodeController.getTabComponent();
        this.dataMapView = new DataMapTabbedView(this.eventController);
        this.detailPanel.add((Component)this.dataMapView, DATA_MAP_VIEW);
        this.procedureView = new ProcedureTabbedView(this.eventController);
        this.detailPanel.add((Component)this.procedureView, PROCEDURE_VIEW);
        this.selectQueryView = new SelectQueryTabbedView(this.eventController);
        this.detailPanel.add((Component)this.selectQueryView, SELECT_QUERY_VIEW);
        this.sqlTemplateView = new SQLTemplateTabbedView(this.eventController);
        this.detailPanel.add((Component)this.sqlTemplateView, SQL_TEMPLATE_VIEW);
        ProcedureQueryView procedureQueryView = new ProcedureQueryView(this.eventController);
        this.detailPanel.add((Component)new JScrollPane(procedureQueryView), PROCEDURE_QUERY_VIEW);
        this.ejbqlQueryView = new EjbqlTabbedView(this.eventController);
        this.detailPanel.add((Component)this.ejbqlQueryView, EJBQL_QUERY_VIEW);
        this.embeddableView = new EmbeddableTabbedView(this.eventController);
        this.detailPanel.add((Component)new JScrollPane(this.embeddableView), EMBEDDABLE_VIEW);
        this.objDetailView = new ObjEntityTabbedView(this.eventController);
        this.detailPanel.add((Component)this.objDetailView, OBJ_VIEW);
        this.dbDetailView = new DbEntityTabbedView(this.eventController);
        this.detailPanel.add((Component)this.dbDetailView, DB_VIEW);
        this.leftPanel.add((Component)barPanel, "North");
        this.leftPanel.add((Component)new JScrollPane(treeNavigatePanel), "Center");
        this.splitPane.setLeftComponent(this.leftPanel);
        this.splitPane.setRightComponent(this.detailPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
    }

    private <T extends Action> T getAction(Class<T> type) {
        return this.actionManager.getAction(type);
    }

    private void initController() {
        this.filterController = new FilterController(this.eventController, this.treePanel);
        this.eventController.addDomainDisplayListener(this);
        this.eventController.addDataNodeDisplayListener(this);
        this.eventController.addDataMapDisplayListener(this);
        this.eventController.addObjEntityDisplayListener(this);
        this.eventController.addDbEntityDisplayListener(this);
        this.eventController.addProcedureDisplayListener(this);
        this.eventController.addQueryDisplayListener(this);
        this.eventController.addMultipleObjectsDisplayListener(this);
        this.eventController.addEmbeddableDisplayListener(this);
        try {
            ComponentGeometry geometry = new ComponentGeometry(this.getClass(), "splitPane/divider");
            geometry.bindIntProperty(this.splitPane, "dividerLocation", 150);
        }
        catch (Exception ex) {
            LogFactory.getLog(this.getClass()).error((Object)"Cannot bind divider property", (Throwable)ex);
        }
    }

    @Override
    public void currentProcedureChanged(ProcedureDisplayEvent e) {
        if (e.getProcedure() == null) {
            this.detailLayout.show(this.detailPanel, EMPTY_VIEW);
        } else {
            this.detailLayout.show(this.detailPanel, PROCEDURE_VIEW);
        }
    }

    @Override
    public void currentDomainChanged(DomainDisplayEvent e) {
        if (e.getDomain() == null) {
            this.detailLayout.show(this.detailPanel, EMPTY_VIEW);
        } else {
            this.detailLayout.show(this.detailPanel, DOMAIN_VIEW);
        }
    }

    @Override
    public void currentDataNodeChanged(DataNodeDisplayEvent e) {
        if (e.getDataNode() == null) {
            this.detailLayout.show(this.detailPanel, EMPTY_VIEW);
        } else {
            this.detailLayout.show(this.detailPanel, NODE_VIEW);
        }
    }

    @Override
    public void currentDataMapChanged(DataMapDisplayEvent e) {
        if (e.getDataMap() == null) {
            this.detailLayout.show(this.detailPanel, EMPTY_VIEW);
        } else {
            this.detailLayout.show(this.detailPanel, DATA_MAP_VIEW);
        }
    }

    @Override
    public void currentObjEntityChanged(EntityDisplayEvent e) {
        if (e.getEntity() == null) {
            this.detailLayout.show(this.detailPanel, EMPTY_VIEW);
        } else {
            this.detailLayout.show(this.detailPanel, OBJ_VIEW);
        }
    }

    @Override
    public void currentDbEntityChanged(EntityDisplayEvent e) {
        if (e.getEntity() == null) {
            this.detailLayout.show(this.detailPanel, EMPTY_VIEW);
        } else {
            this.detailLayout.show(this.detailPanel, DB_VIEW);
        }
    }

    @Override
    public void currentQueryChanged(QueryDisplayEvent e) {
        Query query = e.getQuery();
        if (query instanceof SelectQuery) {
            this.detailLayout.show(this.detailPanel, SELECT_QUERY_VIEW);
        } else if (query instanceof SQLTemplate) {
            this.detailLayout.show(this.detailPanel, SQL_TEMPLATE_VIEW);
        } else if (query instanceof ProcedureQuery) {
            this.detailLayout.show(this.detailPanel, PROCEDURE_QUERY_VIEW);
        } else if (query instanceof EJBQLQuery) {
            this.detailLayout.show(this.detailPanel, EJBQL_QUERY_VIEW);
        } else {
            this.detailLayout.show(this.detailPanel, EMPTY_VIEW);
        }
    }

    @Override
    public void currentObjectsChanged(MultipleObjectsDisplayEvent e, Application application) {
        this.detailLayout.show(this.detailPanel, EMPTY_VIEW);
    }

    @Override
    public void currentEmbeddableChanged(EmbeddableDisplayEvent e) {
        if (e.getEmbeddable() == null) {
            this.detailLayout.show(this.detailPanel, EMPTY_VIEW);
        } else {
            this.detailLayout.show(this.detailPanel, EMBEDDABLE_VIEW);
        }
    }
}

