/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.EventObject;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.event.EmbeddableAttributeEvent;
import org.apache.cayenne.map.event.EmbeddableAttributeListener;
import org.apache.cayenne.map.event.EmbeddableEvent;
import org.apache.cayenne.map.event.EmbeddableListener;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.CopyAttributeAction;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.CutAttributeAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.RemoveAttributeAction;
import org.apache.cayenne.modeler.editor.EmbeddableAttributeTableModel;
import org.apache.cayenne.modeler.editor.ExistingSelectionProcessor;
import org.apache.cayenne.modeler.event.EmbeddableAttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableDisplayListener;
import org.apache.cayenne.modeler.event.TablePopupHandler;
import org.apache.cayenne.modeler.pref.TableColumnPreferences;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.apache.cayenne.modeler.util.UIUtil;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;

public class EmbeddableAttributeTab
extends JPanel
implements EmbeddableAttributeListener,
EmbeddableDisplayListener,
EmbeddableListener,
ExistingSelectionProcessor {
    protected ProjectController mediator;
    protected CayenneTable table;
    protected TableColumnPreferences tablePreferences;
    JButton resolve;

    public EmbeddableAttributeTab(ProjectController mediator) {
        this.mediator = mediator;
        this.init();
        this.initController();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        ActionManager actionManager = Application.getInstance().getActionManager();
        toolBar.add(actionManager.getAction(CreateAttributeAction.class).buildButton());
        toolBar.addSeparator();
        toolBar.add(actionManager.getAction(RemoveAttributeAction.class).buildButton());
        toolBar.addSeparator();
        toolBar.add(actionManager.getAction(CutAttributeAction.class).buildButton());
        toolBar.add(actionManager.getAction(CopyAttributeAction.class).buildButton());
        toolBar.add(actionManager.getAction(PasteAction.class).buildButton());
        this.add((Component)toolBar, "North");
        this.table = new CayenneTable();
        this.tablePreferences = new TableColumnPreferences(this.getClass(), "embeddable/attributeTable");
        JPopupMenu popup = new JPopupMenu();
        popup.add(actionManager.getAction(RemoveAttributeAction.class).buildMenu());
        popup.addSeparator();
        popup.add(actionManager.getAction(CutAttributeAction.class).buildMenu());
        popup.add(actionManager.getAction(CopyAttributeAction.class).buildMenu());
        popup.add(actionManager.getAction(PasteAction.class).buildMenu());
        TablePopupHandler.install(this.table, popup);
        this.add((Component)PanelFactory.createTablePanel(this.table, null), "Center");
    }

    private void initController() {
        this.mediator.addEmbeddableAttributeListener(this);
        this.mediator.addEmbeddableDisplayListener(this);
        this.mediator.addEmbeddableListener(this);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EmbeddableAttributeTab.this.processExistingSelection(e);
            }
        });
        this.mediator.getApplication().getActionManager().setupCutCopyPaste(this.table, CutAttributeAction.class, CopyAttributeAction.class);
    }

    @Override
    public void processExistingSelection(EventObject e) {
        if (e instanceof ChangeEvent) {
            this.table.clearSelection();
        }
        EmbeddableAttribute[] attrs = new EmbeddableAttribute[]{};
        if (this.table.getSelectedRow() >= 0) {
            EmbeddableAttributeTableModel model = (EmbeddableAttributeTableModel)this.table.getModel();
            int[] sel = this.table.getSelectedRows();
            attrs = new EmbeddableAttribute[sel.length];
            for (int i = 0; i < sel.length; ++i) {
                attrs[i] = model.getEmbeddableAttribute(sel[i]);
            }
            if (sel.length == 1) {
                UIUtil.scrollToSelectedRow(this.table);
            }
        }
        EmbeddableAttributeDisplayEvent ev = new EmbeddableAttributeDisplayEvent((Object)this, this.mediator.getCurrentEmbeddable(), attrs, this.mediator.getCurrentDataMap(), (DataChannelDescriptor)this.mediator.getProject().getRootNode());
        this.mediator.fireEmbeddableAttributeDisplayEvent(ev);
    }

    private void rebuildTable(Embeddable emb) {
        EmbeddableAttributeTableModel model = new EmbeddableAttributeTableModel(emb, this.mediator, this);
        this.table.setModel(model);
        this.table.setRowHeight(25);
        this.table.setRowMargin(3);
        this.setUpTableStructure(model);
    }

    private void setUpTableStructure(EmbeddableAttributeTableModel model) {
        TableColumn typeColumn = this.table.getColumnModel().getColumn(1);
        JComboBox javaTypesCombo = Application.getWidgetFactory().createComboBox(ModelerUtil.getRegisteredTypeNames(), false);
        AutoCompletion.enable(javaTypesCombo, false, true);
        typeColumn.setCellEditor(Application.getWidgetFactory().createCellEditor(javaTypesCombo));
        this.tablePreferences.bind(this.table, null, null, null, 0, true);
    }

    public void selectAttributes(EmbeddableAttribute[] embAttrs) {
        ModelerUtil.updateActions(embAttrs.length, RemoveAttributeAction.class, CopyAttributeAction.class, CutAttributeAction.class);
        EmbeddableAttributeTableModel model = (EmbeddableAttributeTableModel)this.table.getModel();
        List listAttrs = model.getObjectList();
        int[] newSel = new int[embAttrs.length];
        for (int i = 0; i < embAttrs.length; ++i) {
            newSel[i] = listAttrs.indexOf(embAttrs[i]);
        }
        this.table.select(newSel);
    }

    public void embeddableAttributeAdded(EmbeddableAttributeEvent e) {
        this.rebuildTable(e.getEmbeddable());
        this.table.select(e.getEmbeddableAttribute());
    }

    public void embeddableAttributeChanged(EmbeddableAttributeEvent e) {
        this.table.select(e.getEmbeddableAttribute());
    }

    public void embeddableAttributeRemoved(EmbeddableAttributeEvent e) {
        EmbeddableAttributeTableModel model = (EmbeddableAttributeTableModel)this.table.getModel();
        int ind = model.getObjectList().indexOf(e.getEmbeddableAttribute());
        model.removeRow(e.getEmbeddableAttribute());
        this.table.select(ind);
    }

    @Override
    public void currentEmbeddableChanged(EmbeddableDisplayEvent e) {
        if (e.getSource() == this) {
            return;
        }
        Embeddable embeddable = e.getEmbeddable();
        if (embeddable != null) {
            this.rebuildTable(embeddable);
        }
    }

    public void embeddableAdded(EmbeddableEvent e, DataMap map) {
    }

    public void embeddableRemoved(EmbeddableEvent e, DataMap map) {
    }

    public void embeddableChanged(EmbeddableEvent e, DataMap map) {
        if (e.getOldName() != null) {
            map.getEmbeddable(e.getOldName()).setClassName(e.getEmbeddable().getClassName());
            if (map.getEmbeddableMap().containsKey(e.getOldName())) {
                map.removeEmbeddable(e.getOldName());
                map.addEmbeddable(e.getEmbeddable());
            }
        }
    }
}

