/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.event.EmbeddableAttributeEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.CayenneTableModel;
import org.apache.cayenne.modeler.util.CellEditorForAttributeTable;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.util.Util;

public class EmbeddableAttributeTableModel
extends CayenneTableModel {
    private Embeddable embeddable;
    static final int OBJ_ATTRIBUTE = 0;
    static final int OBJ_ATTRIBUTE_TYPE = 1;
    static final int DB_ATTRIBUTE = 2;
    private CellEditorForAttributeTable cellEditor;

    public EmbeddableAttributeTableModel(Embeddable embeddable, ProjectController mediator, Object eventSource) {
        super(mediator, eventSource, new ArrayList(embeddable.getAttributes()));
        this.embeddable = embeddable;
    }

    public EmbeddableAttribute getEmbeddableAttribute(int row) {
        return row >= 0 && row < this.objectList.size() ? (EmbeddableAttribute)this.objectList.get(row) : null;
    }

    @Override
    public Class<?> getElementsClass() {
        return EmbeddableAttribute.class;
    }

    @Override
    public void setUpdatedValueAt(Object value, int row, int col) {
        EmbeddableAttribute attribute = this.getEmbeddableAttribute(row);
        EmbeddableAttributeEvent event = new EmbeddableAttributeEvent(this.eventSource, this.embeddable, attribute);
        Object path = null;
        Object nameAttr = null;
        if (col == 0) {
            event.setOldName(attribute.getName());
            ProjectUtil.setEmbeddableAttributeName(attribute, value != null ? value.toString().trim() : null);
            this.fireTableCellUpdated(row, col);
        } else if (col == 1) {
            attribute.setType(value != null ? value.toString() : null);
            this.fireTableCellUpdated(row, col);
        } else if (col == 2) {
            attribute.setDbAttributeName(value != null ? value.toString() : null);
            this.fireTableCellUpdated(row, col);
        }
        this.mediator.fireEmbeddableAttributeEvent(event);
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "ObjAttribute";
            }
            case 1: {
                return "Java Type";
            }
            case 2: {
                return "DbAttribute";
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int column) {
        EmbeddableAttribute attribute = this.getEmbeddableAttribute(row);
        if (column == 0) {
            return attribute.getName();
        }
        if (column == 1) {
            return attribute.getType();
        }
        if (column == 2) {
            return attribute.getDbAttributeName();
        }
        return null;
    }

    public CellEditorForAttributeTable setCellEditor(Collection<String> nameAttr, CayenneTable table) {
        this.cellEditor = new CellEditorForAttributeTable(table, Application.getWidgetFactory().createComboBox(nameAttr, true));
        return this.cellEditor;
    }

    public CellEditorForAttributeTable getCellEditor() {
        return this.cellEditor;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public boolean isColumnSortable(int sortCol) {
        return true;
    }

    @Override
    public void sortByColumn(int sortCol, boolean isAscent) {
        switch (sortCol) {
            case 0: {
                this.sortByElementProperty("name", isAscent);
                break;
            }
            case 1: {
                this.sortByElementProperty("type", isAscent);
                break;
            }
            case 2: {
                this.sortByElementProperty("dbAttributeName", isAscent);
            }
        }
    }

    final class EmbeddableAttributeComparator
    implements Comparator {
        EmbeddableAttributeComparator() {
        }

        public int compare(Object o1, Object o2) {
            EmbeddableAttribute a1 = (EmbeddableAttribute)o1;
            EmbeddableAttribute a2 = (EmbeddableAttribute)o2;
            int delta = this.getWeight(a1) - this.getWeight(a2);
            return delta != 0 ? delta : Util.nullSafeCompare((boolean)true, (Comparable)((Object)a1.getName()), (Object)a2.getName());
        }

        private int getWeight(EmbeddableAttribute a) {
            return a.getEmbeddable() == EmbeddableAttributeTableModel.this.embeddable ? 1 : -1;
        }
    }
}

