/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.EmbeddableEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.event.EmbeddableDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableDisplayListener;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;

public class EmbeddableTab
extends JPanel
implements EmbeddableDisplayListener {
    protected ProjectController mediator;
    protected TextAdapter className;

    public EmbeddableTab(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
        this.initController();
    }

    private void initController() {
        this.mediator.addEmbeddableDisplayListener(this);
    }

    private void initView() {
        this.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        ActionManager actionManager = Application.getInstance().getActionManager();
        toolBar.add(actionManager.getAction(CreateAttributeAction.class).buildButton());
        this.add((Component)toolBar, "North");
        this.className = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                EmbeddableTab.this.setClassName(text);
            }
        };
        FormLayout layout = new FormLayout("right:50dlu, 3dlu, fill:150dlu, 3dlu, fill:100", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append("Class Name:", (Component)this.className.getComponent(), 3);
        this.add((Component)builder.getPanel(), "Center");
    }

    public void processExistingSelection(EventObject e) {
        EmbeddableDisplayEvent ede = new EmbeddableDisplayEvent((Object)this, this.mediator.getCurrentEmbeddable(), this.mediator.getCurrentDataMap(), (DataChannelDescriptor)this.mediator.getProject().getRootNode());
        this.mediator.fireEmbeddableDisplayEvent(ede);
    }

    void setClassName(String newClassName) {
        Embeddable embeddable;
        if (newClassName != null && newClassName.trim().length() == 0) {
            newClassName = null;
        }
        if ((embeddable = this.mediator.getCurrentEmbeddable()) == null) {
            return;
        }
        if (Util.nullSafeEquals((Object)newClassName, (Object)embeddable.getClassName())) {
            return;
        }
        if (newClassName == null) {
            throw new ValidationException("Embeddable name is required.", new Object[0]);
        }
        if (embeddable.getDataMap().getEmbeddable(newClassName) == null) {
            DataChannelDescriptor domain = (DataChannelDescriptor)this.mediator.getProject().getRootNode();
            if (domain != null) {
                for (DataMap nextMap : domain.getDataMaps()) {
                    Embeddable conflictingEmbeddable;
                    if (nextMap == embeddable.getDataMap() || (conflictingEmbeddable = nextMap.getEmbeddable(newClassName)) == null) continue;
                    throw new ValidationException("Duplicate Embeddable name in another DataMap: " + newClassName + ".", new Object[0]);
                }
            }
            EmbeddableEvent e = new EmbeddableEvent((Object)this, embeddable, embeddable.getClassName());
            String oldName = embeddable.getClassName();
            embeddable.setClassName(newClassName);
            this.mediator.fireEmbeddableEvent(e, this.mediator.getCurrentDataMap());
            for (DataMap dataMap : ((DataChannelDescriptor)this.mediator.getProject().getRootNode()).getDataMaps()) {
                Iterator ent = dataMap.getObjEntities().iterator();
                while (ent.hasNext()) {
                    Collection attr = ((ObjEntity)ent.next()).getAttributes();
                    for (ObjAttribute atribute : attr) {
                        if (atribute.getType() != null && !atribute.getType().equals(oldName)) continue;
                        atribute.setType(newClassName);
                        AttributeEvent ev = new AttributeEvent((Object)this, (Attribute)atribute, (Entity)atribute.getEntity());
                        this.mediator.fireObjAttributeEvent(ev);
                    }
                }
            }
        } else {
            throw new ValidationException("There is another embeddable with name '" + newClassName + "'.", new Object[0]);
        }
    }

    @Override
    public void currentEmbeddableChanged(EmbeddableDisplayEvent e) {
        Embeddable embeddable = e.getEmbeddable();
        if (embeddable == null || !e.isEmbeddableChanged()) {
            return;
        }
        this.initFromModel(embeddable);
    }

    private void initFromModel(Embeddable embeddable) {
        this.className.setText(embeddable.getClassName());
    }
}

