/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.wrapper.ObjAttributeWrapper;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.CayenneTableModel;
import org.apache.cayenne.modeler.util.CellEditorForAttributeTable;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.util.Util;

public class ObjAttributeTableModel
extends CayenneTableModel<ObjAttributeWrapper> {
    public static final int INHERITED = 0;
    public static final int OBJ_ATTRIBUTE = 1;
    public static final int OBJ_ATTRIBUTE_TYPE = 2;
    public static final int DB_ATTRIBUTE = 3;
    public static final int DB_ATTRIBUTE_TYPE = 4;
    public static final int LOCKING = 5;
    protected ObjEntity entity;
    protected DbEntity dbEntity;
    private CellEditorForAttributeTable cellEditor;
    private CayenneTable table;

    private static List<ObjAttributeWrapper> wrapObjAttributes(Collection<ObjAttribute> attributes) {
        ArrayList<ObjAttributeWrapper> wrappedAttributes = new ArrayList<ObjAttributeWrapper>();
        for (ObjAttribute attr : attributes) {
            wrappedAttributes.add(new ObjAttributeWrapper(attr));
        }
        return wrappedAttributes;
    }

    public ObjAttributeTableModel(ObjEntity entity, ProjectController mediator, Object eventSource) {
        super(mediator, eventSource, ObjAttributeTableModel.wrapObjAttributes(entity.getAttributes()));
        this.entity = entity;
        this.dbEntity = entity.getDbEntity();
        Collections.sort(this.objectList, new AttributeComparator());
    }

    @Override
    protected void orderList() {
    }

    public CayenneTable getTable() {
        return this.table;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 5: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public Class<?> getElementsClass() {
        return ObjAttributeWrapper.class;
    }

    public DbEntity getDbEntity() {
        return this.dbEntity;
    }

    public ObjAttributeWrapper getAttribute(int row) {
        return row >= 0 && row < this.objectList.size() ? (ObjAttributeWrapper)this.objectList.get(row) : null;
    }

    public void resetDbEntity() {
        if (this.dbEntity == this.entity.getDbEntity()) {
            return;
        }
        boolean wasShowing = this.isShowingDb();
        this.dbEntity = this.entity.getDbEntity();
        boolean isShowing = this.isShowingDb();
        if (wasShowing != isShowing) {
            this.fireTableStructureChanged();
        }
        this.fireTableDataChanged();
    }

    private boolean isShowingDb() {
        return this.dbEntity != null;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "In";
            }
            case 1: {
                return "Name";
            }
            case 2: {
                return "Java Type";
            }
            case 3: {
                return "DbAttribute";
            }
            case 4: {
                return "DB Type";
            }
            case 5: {
                return "Used for Locking";
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int column) {
        ObjAttributeWrapper attribute = this.getAttribute(row);
        if (column == 0) {
            return attribute.isInherited();
        }
        if (column == 1) {
            return attribute.getName();
        }
        if (column == 2) {
            return attribute.getType();
        }
        if (column == 5) {
            return attribute.isUsedForLocking() ? Boolean.TRUE : Boolean.FALSE;
        }
        DbAttribute dbAttribute = attribute.getDbAttribute();
        if (column == 3) {
            return this.getDBAttribute(attribute, dbAttribute);
        }
        if (column == 4) {
            return this.getDBAttributeType(attribute, dbAttribute);
        }
        return null;
    }

    private String getDBAttribute(ObjAttributeWrapper attribute, DbAttribute dbAttribute) {
        if (dbAttribute == null) {
            if (!attribute.isInherited() && attribute.getEntity().isAbstract()) {
                return attribute.getDbAttributePath();
            }
            return null;
        }
        if (attribute.getDbAttributePath() != null && attribute.getDbAttributePath().contains(".")) {
            return attribute.getDbAttributePath();
        }
        return dbAttribute.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDBAttributeType(ObjAttributeWrapper attribute, DbAttribute dbAttribute) {
        int type;
        if (dbAttribute == null) {
            if (attribute.getValue() instanceof EmbeddedAttribute) return null;
            try {
                type = TypesMapping.getSqlTypeByJava(attribute.getJavaClass());
                return TypesMapping.getSqlNameByType((int)type);
            }
            catch (CayenneRuntimeException cre) {
                return null;
            }
        } else {
            type = dbAttribute.getType();
        }
        return TypesMapping.getSqlNameByType((int)type);
    }

    public CellEditorForAttributeTable setCellEditor(Collection<String> nameAttr, CayenneTable table) {
        this.cellEditor = new CellEditorForAttributeTable(table, Application.getWidgetFactory().createComboBox(nameAttr, true));
        this.table = table;
        return this.cellEditor;
    }

    public CellEditorForAttributeTable getCellEditor() {
        return this.cellEditor;
    }

    @Override
    public void resetModel() {
        for (ObjAttributeWrapper attribute : this.objectList) {
            attribute.resetEdits();
        }
    }

    @Override
    public boolean isValid() {
        for (ObjAttributeWrapper attribute : this.getObjectList()) {
            if (attribute.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setUpdatedValueAt(Object value, int row, int column) {
        ObjAttributeWrapper attribute = this.getAttribute(row);
        attribute.resetEdits();
        AttributeEvent event = new AttributeEvent(this.eventSource, (Attribute)attribute.getValue(), (Entity)this.entity);
        String path = null;
        Collection<String> nameAttr = null;
        if (column == 1) {
            event.setOldName(attribute.getName());
            attribute.setName(value != null ? value.toString().trim() : null);
            if (attribute.isValid()) {
                attribute.commitEdits();
            }
            this.fireTableCellUpdated(row, column);
        } else if (column == 2) {
            String oldType = attribute.getType();
            attribute.setType(value != null ? value.toString() : null);
            String newType = attribute.getType();
            String[] registeredTypes = ModelerUtil.getRegisteredTypeNames();
            List<String> registeredTypesList = Arrays.asList(registeredTypes);
            if (oldType != null && newType != null && registeredTypesList.contains(oldType) != registeredTypesList.contains(newType)) {
                ObjAttribute attributeNew;
                ArrayList<Embeddable> embs = this.mediator.getEmbeddableNamesInCurRentDataDomain();
                ArrayList<String> embNames = new ArrayList<String>();
                Iterator<Embeddable> it = embs.iterator();
                while (it.hasNext()) {
                    embNames.add(it.next().getClassName());
                }
                if (registeredTypesList.contains(newType) || !embNames.contains(newType)) {
                    attributeNew = new ObjAttribute();
                } else {
                    attributeNew = new EmbeddedAttribute();
                    attribute.setDbAttributePath(null);
                }
                attributeNew.setDbAttributePath(attribute.getDbAttributePath());
                attributeNew.setName(attribute.getName());
                attributeNew.setEntity((Entity)attribute.getEntity());
                attributeNew.setParent(attribute.getParent());
                attributeNew.setType(attribute.getType());
                attributeNew.setUsedForLocking(attribute.isUsedForLocking());
                ObjEntity ent = attribute.getEntity();
                ent.removeAttribute(attribute.getName());
                ent.addAttribute((Attribute)attributeNew);
                this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, (Entity)ent, 1));
                EntityDisplayEvent ev = new EntityDisplayEvent((Object)this, (Entity)this.mediator.getCurrentObjEntity(), this.mediator.getCurrentDataMap(), (DataChannelDescriptor)this.mediator.getProject().getRootNode());
                this.mediator.fireObjEntityDisplayEvent(ev);
                this.mediator.fireObjAttributeEvent(new AttributeEvent((Object)this, (Attribute)attributeNew, (Entity)ent, 1));
                AttributeDisplayEvent eventAttr = new AttributeDisplayEvent((Object)this, (Attribute)attributeNew, (Entity)this.mediator.getCurrentObjEntity(), this.mediator.getCurrentDataMap(), (DataChannelDescriptor)this.mediator.getProject().getRootNode());
                this.mediator.fireObjAttributeDisplayEvent(eventAttr);
            }
            this.fireTableCellUpdated(row, column);
        } else if (column == 5) {
            attribute.setUsedForLocking(value instanceof Boolean && (Boolean)value != false);
            this.fireTableCellUpdated(row, column);
        } else {
            if (column == 3) {
                if (value != null) {
                    path = value.toString();
                    String[] pathSplit = path.split("\\.");
                    if (pathSplit.length > 1) {
                        DbEntity currentEnt = this.dbEntity;
                        StringBuilder pathBuf = new StringBuilder();
                        boolean isTruePath = true;
                        if (this.dbEntity != null) {
                            nameAttr = ModelerUtil.getDbAttributeNames(this.mediator, this.dbEntity);
                            for (int j = 0; j < pathSplit.length; ++j) {
                                if (j == pathSplit.length - 1 && isTruePath) {
                                    DbAttribute dbAttribute = currentEnt.getAttribute(pathSplit[j]);
                                    if (dbAttribute != null) {
                                        pathBuf.append(dbAttribute.getName());
                                        continue;
                                    }
                                    isTruePath = false;
                                    continue;
                                }
                                if (!isTruePath) continue;
                                DbRelationship dbRelationship = currentEnt.getRelationship(pathSplit[j]);
                                if (dbRelationship != null) {
                                    currentEnt = dbRelationship.getTargetEntity();
                                    pathBuf.append(dbRelationship.getName());
                                    pathBuf.append(".");
                                    continue;
                                }
                                isTruePath = false;
                            }
                        }
                        path = isTruePath ? pathBuf.toString() : null;
                    } else if (this.dbEntity != null) {
                        DbAttribute dbAttribute = this.dbEntity.getAttribute(value.toString());
                        path = dbAttribute != null ? dbAttribute.getName() : null;
                    }
                    attribute.setDbAttributePath(path);
                } else if (attribute.getDbAttribute() != null) {
                    attribute.setDbAttributePath(null);
                }
                if (path != null && path.split("\\.").length > 1 && this.dbEntity != null) {
                    this.setComboBoxes(nameAttr, column);
                }
            }
            this.fireTableRowsUpdated(row, row);
        }
        this.mediator.fireObjAttributeEvent(event);
    }

    public void setComboBoxes(Collection<String> nameAttr, int column) {
        int count = this.getRowCount();
        for (int i = 0; i < count; ++i) {
            if (this.getAttribute(i).getDbAttributePath() == null || !this.getAttribute(i).getDbAttributePath().contains(".")) continue;
            ArrayList<String> attributeComboForRow = new ArrayList<String>();
            attributeComboForRow.addAll(nameAttr);
            attributeComboForRow.add(this.getAttribute(i).getDbAttributePath());
            JComboBox comboBoxForRow = Application.getWidgetFactory().createComboBox(attributeComboForRow, true);
            this.cellEditor.setEditorAt(new Integer(i), new DefaultCellEditor(comboBoxForRow));
        }
        this.table.getColumnModel().getColumn(column).setCellEditor(this.cellEditor);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.getAttribute(row).isInherited()) {
            return col == 3;
        }
        return col != 4 && col != 0;
    }

    public ObjEntity getEntity() {
        return this.entity;
    }

    @Override
    public void sortByColumn(final int sortCol, boolean isAscent) {
        switch (sortCol) {
            case 0: {
                this.sortByElementProperty("inherited", isAscent);
                break;
            }
            case 1: {
                this.sortByElementProperty("name", isAscent);
                break;
            }
            case 2: {
                this.sortByElementProperty("type", isAscent);
                break;
            }
            case 5: {
                this.sortByElementProperty("usedForLocking", isAscent);
                break;
            }
            case 3: 
            case 4: {
                Collections.sort(this.objectList, new Comparator<ObjAttributeWrapper>(){

                    @Override
                    public int compare(ObjAttributeWrapper o1, ObjAttributeWrapper o2) {
                        Integer compareObjAttributesVal = ObjAttributeTableModel.this.compareObjAttributes(o1, o2);
                        if (compareObjAttributesVal != null) {
                            return compareObjAttributesVal;
                        }
                        String valToCompare1 = ObjAttributeTableModel.this.getDBAttribute(o1, o1.getDbAttribute());
                        String valToCompare2 = ObjAttributeTableModel.this.getDBAttribute(o2, o2.getDbAttribute());
                        switch (sortCol) {
                            case 3: {
                                valToCompare1 = ObjAttributeTableModel.this.getDBAttribute(o1, o1.getDbAttribute());
                                valToCompare2 = ObjAttributeTableModel.this.getDBAttribute(o2, o2.getDbAttribute());
                                break;
                            }
                            case 4: {
                                valToCompare1 = ObjAttributeTableModel.this.getDBAttributeType(o1, o1.getDbAttribute());
                                valToCompare2 = ObjAttributeTableModel.this.getDBAttributeType(o2, o2.getDbAttribute());
                            }
                        }
                        return valToCompare1 == null ? -1 : (valToCompare2 == null ? 1 : valToCompare1.compareTo(valToCompare2));
                    }
                });
                if (isAscent) break;
                Collections.reverse(this.objectList);
            }
        }
    }

    @Override
    public boolean isColumnSortable(int sortCol) {
        return true;
    }

    private Integer compareObjAttributes(ObjAttributeWrapper o1, ObjAttributeWrapper o2) {
        if (o1 == null && o2 == null || o1 == o2) {
            return 0;
        }
        if (o1 == null && o2 != null) {
            return -1;
        }
        if (o1 != null && o2 == null) {
            return 1;
        }
        return null;
    }

    final class AttributeComparator
    implements Comparator {
        AttributeComparator() {
        }

        public int compare(Object o1, Object o2) {
            ObjAttribute a1 = ((ObjAttributeWrapper)o1).getValue();
            ObjAttribute a2 = ((ObjAttributeWrapper)o2).getValue();
            int delta = this.getWeight((Attribute)a1) - this.getWeight((Attribute)a2);
            return delta != 0 ? delta : Util.nullSafeCompare((boolean)true, (Comparable)((Object)a1.getName()), (Object)a2.getName());
        }

        private int getWeight(Attribute a) {
            return a.getEntity() == ObjAttributeTableModel.this.entity ? 1 : -1;
        }
    }
}

