/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjAttributeListener;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.CopyAttributeRelationshipAction;
import org.apache.cayenne.modeler.action.CutAttributeRelationshipAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.RemoveAttributeRelationshipAction;
import org.apache.cayenne.modeler.dialog.objentity.ObjAttributeInfoDialog;
import org.apache.cayenne.modeler.editor.ObjAttributeTableModel;
import org.apache.cayenne.modeler.editor.ObjEntityAttributeRelationshipTab;
import org.apache.cayenne.modeler.editor.wrapper.ObjAttributeWrapper;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.event.ProjectOnSaveEvent;
import org.apache.cayenne.modeler.event.ProjectOnSaveListener;
import org.apache.cayenne.modeler.event.TablePopupHandler;
import org.apache.cayenne.modeler.pref.TableColumnPreferences;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.CayenneTableModel;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.apache.cayenne.modeler.util.UIUtil;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;

public class ObjEntityAttributePanel
extends JPanel
implements ObjEntityDisplayListener,
ObjEntityListener,
ObjAttributeListener,
ProjectOnSaveListener {
    protected ProjectController mediator;
    protected CayenneTable table;
    private TableColumnPreferences tablePreferences;
    private ObjEntityAttributeRelationshipTab parentPanel;
    private boolean enabledResolve;
    private ActionListener resolver;
    protected JMenuItem resolveMenu;

    public ObjEntityAttributePanel(ProjectController mediator, ObjEntityAttributeRelationshipTab parentPanel) {
        this.mediator = mediator;
        this.parentPanel = parentPanel;
        this.initView();
        this.initController();
    }

    private void initView() {
        this.setLayout(new BorderLayout());
        ActionManager actionManager = Application.getInstance().getActionManager();
        this.table = new CayenneTable();
        this.table.setDefaultRenderer(String.class, new CellRenderer());
        this.tablePreferences = new TableColumnPreferences(ObjAttributeTableModel.class, "objEntity/attributeTable");
        ImageIcon ico = ModelerUtil.buildIcon("icon-info.gif");
        this.resolveMenu = new JMenuItem("Database Mapping", ico);
        JPopupMenu popup = new JPopupMenu();
        popup.add(this.resolveMenu);
        popup.add(actionManager.getAction(RemoveAttributeRelationshipAction.class).buildMenu());
        popup.addSeparator();
        popup.add(actionManager.getAction(CutAttributeRelationshipAction.class).buildMenu());
        popup.add(actionManager.getAction(CopyAttributeRelationshipAction.class).buildMenu());
        popup.add(actionManager.getAction(PasteAction.class).buildMenu());
        TablePopupHandler.install(this.table, popup);
        this.add((Component)PanelFactory.createTablePanel(this.table, null), "Center");
    }

    private void initController() {
        this.mediator.addObjEntityDisplayListener(this);
        this.mediator.addObjEntityListener(this);
        this.mediator.addObjAttributeListener(this);
        this.resolver = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ObjEntityAttributePanel.this.table.getSelectedRow();
                if (row < 0) {
                    return;
                }
                ObjAttributeTableModel model = (ObjAttributeTableModel)ObjEntityAttributePanel.this.table.getModel();
                new ObjAttributeInfoDialog(ObjEntityAttributePanel.this.mediator, row, model).startupAction();
                ObjEntityAttributePanel.this.table.cancelEditing();
                ObjEntityAttributePanel.this.table.getSelectionModel().clearSelection();
                ObjEntityAttributePanel.this.table.select(row);
                ObjEntityAttributePanel.this.enabledResolve = false;
            }
        };
        this.resolveMenu.addActionListener(this.resolver);
        this.table.getSelectionModel().addListSelectionListener(new ObjAttributeListSelectionListener());
        this.table.setAutoResizeMode(0);
        this.table.setAutoCreateRowSorter(true);
        this.mediator.getApplication().getActionManager().setupCutCopyPaste(this.table, CutAttributeRelationshipAction.class, CopyAttributeRelationshipAction.class);
    }

    public void initComboBoxes(ObjAttributeTableModel model) {
        ArrayList<String> embeddableNames = new ArrayList<String>();
        ArrayList<String> typeNames = new ArrayList<String>();
        for (DataMap dataMap : ((DataChannelDescriptor)this.mediator.getProject().getRootNode()).getDataMaps()) {
            for (Embeddable emb : dataMap.getEmbeddables()) {
                embeddableNames.add(emb.getClassName());
            }
        }
        String[] registeredTypes = ModelerUtil.getRegisteredTypeNames();
        for (int i = 0; i < registeredTypes.length; ++i) {
            typeNames.add(registeredTypes[i]);
        }
        typeNames.addAll(embeddableNames);
        TableColumn typeColumn = this.table.getColumnModel().getColumn(2);
        JComboBox javaTypesCombo = Application.getWidgetFactory().createComboBox(typeNames.toArray(), false);
        AutoCompletion.enable(javaTypesCombo, false, true);
        typeColumn.setCellEditor(Application.getWidgetFactory().createCellEditor(javaTypesCombo));
        if (model.getEntity().getDbEntity() != null) {
            Collection<String> nameAttr = ModelerUtil.getDbAttributeNames(this.mediator, model.getEntity().getDbEntity());
            model.setCellEditor(nameAttr, this.table);
            model.setComboBoxes(nameAttr, 3);
        }
    }

    public void selectAttributes(ObjAttribute[] attrs) {
        ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
        List listAttrs = model.getObjectList();
        int[] newSel = new int[attrs.length];
        this.parentPanel.updateActions(attrs);
        block0: for (int i = 0; i < attrs.length; ++i) {
            for (int j = 0; j < listAttrs.size(); ++j) {
                if (((ObjAttributeWrapper)listAttrs.get(j)).getValue() != attrs[i]) continue;
                newSel[i] = j;
                continue block0;
            }
        }
        this.table.select(newSel);
    }

    public void objAttributeChanged(AttributeEvent e) {
        ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
        if (!model.isValid()) {
            model.resetModel();
        }
        model.fireTableDataChanged();
        int ind = -1;
        List list = model.getObjectList();
        for (int i = 0; i < list.size(); ++i) {
            if (((ObjAttributeWrapper)list.get(i)).getValue() != e.getAttribute()) continue;
            ind = i;
        }
        this.table.select(ind);
    }

    public void objAttributeAdded(AttributeEvent e) {
        ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
        if (!model.isValid()) {
            model.resetModel();
        }
        model.addRow(new ObjAttributeWrapper((ObjAttribute)e.getAttribute()));
        model.fireTableDataChanged();
        int ind = -1;
        List list = model.getObjectList();
        for (int i = 0; i < list.size(); ++i) {
            if (((ObjAttributeWrapper)list.get(i)).getValue() != e.getAttribute()) continue;
            ind = i;
        }
        this.table.select(ind);
    }

    public void objAttributeRemoved(AttributeEvent e) {
        ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
        int ind = -1;
        List list = model.getObjectList();
        for (int i = 0; i < list.size(); ++i) {
            if (((ObjAttributeWrapper)list.get(i)).getValue() != e.getAttribute()) continue;
            ind = i;
        }
        if (!model.isValid()) {
            model.resetModel();
        }
        if (ind >= 0) {
            model.removeRow(list.get(ind));
            model.fireTableDataChanged();
            this.table.select(ind);
        }
    }

    @Override
    public void currentObjEntityChanged(EntityDisplayEvent e) {
        if (e.getSource() == this) {
            return;
        }
        ObjEntity entity = (ObjEntity)e.getEntity();
        if (entity != null) {
            this.rebuildTable(entity);
        }
        if (e.isUnselectAttributes()) {
            this.table.clearSelection();
        }
    }

    protected void rebuildTable(ObjEntity entity) {
        if (this.table.getEditingRow() != -1 && this.table.getEditingColumn() != -1) {
            TableCellEditor cellEditor = this.table.getCellEditor(this.table.getEditingRow(), this.table.getEditingColumn());
            cellEditor.stopCellEditing();
        }
        ObjAttributeTableModel model = new ObjAttributeTableModel(entity, this.mediator, this);
        this.table.setModel(model);
        this.table.setRowHeight(25);
        this.table.setRowMargin(3);
        this.setUpTableStructure(model);
    }

    protected void setUpTableStructure(ObjAttributeTableModel model) {
        int inheritanceColumnWidth = 30;
        HashMap<Integer, Integer> minSizes = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> maxSizes = new HashMap<Integer, Integer>();
        minSizes.put(0, inheritanceColumnWidth);
        maxSizes.put(0, inheritanceColumnWidth);
        this.initComboBoxes(model);
        this.tablePreferences.bind(this.table, minSizes, maxSizes, null, 1, true);
    }

    public void objEntityChanged(EntityEvent e) {
        if (e.getSource() == this) {
            return;
        }
        if (!(this.table.getModel() instanceof ObjAttributeTableModel)) {
            return;
        }
        ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
        if (model.getDbEntity() != ((ObjEntity)e.getEntity()).getDbEntity()) {
            model.resetDbEntity();
            this.setUpTableStructure(model);
        }
    }

    public void objEntityAdded(EntityEvent e) {
        if (e.getSource() == this) {
            return;
        }
        this.rebuildTable((ObjEntity)e.getEntity());
    }

    public void objEntityRemoved(EntityEvent e) {
    }

    private void resetTableModel() {
        CayenneTableModel model = this.table.getCayenneModel();
        if (model != null && !model.isValid()) {
            model.resetModel();
            model.fireTableDataChanged();
        }
    }

    @Override
    public void beforeSaveChanges(ProjectOnSaveEvent e) {
        this.resetTableModel();
    }

    public boolean isEnabledResolve() {
        return this.enabledResolve;
    }

    public ActionListener getResolver() {
        return this.resolver;
    }

    private class ObjAttributeListSelectionListener
    implements ListSelectionListener {
        private ObjAttributeListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Object[] attrs = new ObjAttribute[]{};
            if (!e.getValueIsAdjusting() && !((ListSelectionModel)e.getSource()).isSelectionEmpty()) {
                ((ObjEntityAttributePanel)ObjEntityAttributePanel.this).parentPanel.getRelationshipPanel().table.getSelectionModel().clearSelection();
                if (((ObjEntityAttributePanel)ObjEntityAttributePanel.this).parentPanel.getRelationshipPanel().table.getCellEditor() != null) {
                    ((ObjEntityAttributePanel)ObjEntityAttributePanel.this).parentPanel.getRelationshipPanel().table.getCellEditor().stopCellEditing();
                }
                Application.getInstance().getActionManager().getAction(RemoveAttributeRelationshipAction.class).setCurrentSelectedPanel(ObjEntityAttributePanel.this.parentPanel.getAttributePanel());
                Application.getInstance().getActionManager().getAction(CutAttributeRelationshipAction.class).setCurrentSelectedPanel(ObjEntityAttributePanel.this.parentPanel.getAttributePanel());
                Application.getInstance().getActionManager().getAction(CopyAttributeRelationshipAction.class).setCurrentSelectedPanel(ObjEntityAttributePanel.this.parentPanel.getAttributePanel());
                ObjEntityAttributePanel.this.parentPanel.getResolve().removeActionListener(ObjEntityAttributePanel.this.parentPanel.getRelationshipPanel().getResolver());
                ObjEntityAttributePanel.this.parentPanel.getResolve().removeActionListener(ObjEntityAttributePanel.this.getResolver());
                ObjEntityAttributePanel.this.parentPanel.getResolve().addActionListener(ObjEntityAttributePanel.this.getResolver());
                ObjEntityAttributePanel.this.parentPanel.getResolve().setToolTipText("Edit Attribute");
                ObjEntityAttributePanel.this.parentPanel.getResolve().setEnabled(true);
                if (ObjEntityAttributePanel.this.table.getSelectedRow() >= 0) {
                    ObjAttributeTableModel model = (ObjAttributeTableModel)ObjEntityAttributePanel.this.table.getModel();
                    int[] sel = ObjEntityAttributePanel.this.table.getSelectedRows();
                    attrs = new ObjAttribute[sel.length];
                    for (int i = 0; i < sel.length; ++i) {
                        attrs[i] = model.getAttribute(sel[i]).getValue();
                    }
                    if (sel.length == 1) {
                        UIUtil.scrollToSelectedRow(ObjEntityAttributePanel.this.table);
                    }
                    ObjEntityAttributePanel.this.enabledResolve = true;
                } else {
                    ObjEntityAttributePanel.this.enabledResolve = false;
                }
                ObjEntityAttributePanel.this.resolveMenu.setEnabled(ObjEntityAttributePanel.this.enabledResolve);
            }
            ObjEntityAttributePanel.this.mediator.setCurrentObjAttributes((ObjAttribute[])attrs);
            ObjEntityAttributePanel.this.parentPanel.updateActions(attrs);
        }
    }

    final class CellRenderer
    extends DefaultTableCellRenderer {
        CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ObjAttributeTableModel model = (ObjAttributeTableModel)table.getModel();
            column = table.getColumnModel().getColumn(column).getModelIndex();
            ObjAttribute attribute = model.getAttribute(row).getValue();
            if (column != 0) {
                if (!model.isCellEditable(row, column)) {
                    this.setForeground(Color.GRAY);
                } else {
                    this.setForeground(isSelected && !hasFocus ? table.getSelectionForeground() : table.getForeground());
                }
                if (attribute.isInherited()) {
                    Font font = this.getFont();
                    Font newFont = font.deriveFont(2);
                    this.setFont(newFont);
                }
                this.setIcon(null);
            } else {
                if (attribute.isInherited()) {
                    ImageIcon objEntityIcon = ModelerUtil.buildIcon("icon-override.gif");
                    this.setIcon(objEntityIcon);
                }
                this.setText("");
            }
            return this;
        }
    }
}

