/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.CopyAttributeRelationshipAction;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.action.CutAttributeRelationshipAction;
import org.apache.cayenne.modeler.action.ObjEntityCounterpartAction;
import org.apache.cayenne.modeler.action.ObjEntitySyncAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.RemoveAttributeRelationshipAction;
import org.apache.cayenne.modeler.editor.ObjEntityAttributePanel;
import org.apache.cayenne.modeler.editor.ObjEntityRelationshipPanel;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.util.ModelerUtil;

public class ObjEntityAttributeRelationshipTab
extends JPanel
implements ObjEntityDisplayListener,
ObjEntityListener {
    public ObjEntityAttributePanel attributePanel;
    public ObjEntityRelationshipPanel relationshipPanel;
    public JButton resolve = new JButton();
    private JSplitPane splitPane;
    private ProjectController mediator;
    private CutAttributeRelationshipAction cut;
    private RemoveAttributeRelationshipAction remove;
    private CopyAttributeRelationshipAction copy;

    public ObjEntityAttributeRelationshipTab(ProjectController mediator) {
        this.mediator = mediator;
        this.init();
        this.initToolBar();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.attributePanel = new ObjEntityAttributePanel(this.mediator, this);
        this.relationshipPanel = new ObjEntityRelationshipPanel(this.mediator, this);
        this.splitPane = new JSplitPane(0, this.attributePanel, this.relationshipPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setResizeWeight(0.5);
        this.add(this.splitPane);
    }

    private void initToolBar() {
        JToolBar toolBar = new JToolBar();
        ActionManager actionManager = Application.getInstance().getActionManager();
        toolBar.add(actionManager.getAction(CreateAttributeAction.class).buildButton());
        toolBar.add(actionManager.getAction(CreateRelationshipAction.class).buildButton());
        toolBar.add(actionManager.getAction(ObjEntitySyncAction.class).buildButton());
        toolBar.add(actionManager.getAction(ObjEntityCounterpartAction.class).buildButton());
        toolBar.addSeparator();
        ImageIcon ico = ModelerUtil.buildIcon("icon-info.gif");
        this.resolve.setToolTipText("Edit");
        this.resolve.setIcon(ico);
        toolBar.add(this.resolve).setEnabled(false);
        this.cut = actionManager.getAction(CutAttributeRelationshipAction.class);
        this.remove = actionManager.getAction(RemoveAttributeRelationshipAction.class);
        this.copy = actionManager.getAction(CopyAttributeRelationshipAction.class);
        toolBar.addSeparator();
        toolBar.add(this.remove.buildButton());
        toolBar.addSeparator();
        toolBar.add(this.cut.buildButton());
        toolBar.add(this.copy.buildButton());
        toolBar.add(actionManager.getAction(PasteAction.class).buildButton());
        this.add((Component)toolBar, "North");
    }

    public void updateActions(Object[] params) {
        ModelerUtil.updateActions(params.length, RemoveAttributeRelationshipAction.class, CutAttributeRelationshipAction.class, CopyAttributeRelationshipAction.class);
        this.resolve.setEnabled(params.length > 0);
    }

    public JButton getResolve() {
        return this.resolve;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public ObjEntityAttributePanel getAttributePanel() {
        return this.attributePanel;
    }

    public ObjEntityRelationshipPanel getRelationshipPanel() {
        return this.relationshipPanel;
    }

    public void objEntityChanged(EntityEvent e) {
        this.attributePanel.objEntityChanged(e);
        this.relationshipPanel.objEntityChanged(e);
    }

    public void objEntityAdded(EntityEvent e) {
        this.attributePanel.objEntityAdded(e);
        this.relationshipPanel.objEntityAdded(e);
    }

    public void objEntityRemoved(EntityEvent e) {
        this.attributePanel.objEntityRemoved(e);
        this.relationshipPanel.objEntityRemoved(e);
    }

    @Override
    public void currentObjEntityChanged(EntityDisplayEvent e) {
        this.attributePanel.currentObjEntityChanged(e);
        this.relationshipPanel.currentObjEntityChanged(e);
    }
}

