/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DeleteRule;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.map.event.ObjRelationshipListener;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.CopyAttributeRelationshipAction;
import org.apache.cayenne.modeler.action.CutAttributeRelationshipAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.RemoveAttributeRelationshipAction;
import org.apache.cayenne.modeler.dialog.objentity.ObjRelationshipInfo;
import org.apache.cayenne.modeler.editor.ObjEntityAttributeRelationshipTab;
import org.apache.cayenne.modeler.editor.ObjRelationshipTableModel;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.event.TablePopupHandler;
import org.apache.cayenne.modeler.pref.TableColumnPreferences;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.apache.cayenne.modeler.util.UIUtil;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjEntityRelationshipPanel
extends JPanel
implements ObjEntityDisplayListener,
ObjEntityListener,
ObjRelationshipListener {
    private static Log logObj = LogFactory.getLog(ObjEntityRelationshipPanel.class);
    private static final Object[] deleteRules = new Object[]{DeleteRule.deleteRuleName((int)0), DeleteRule.deleteRuleName((int)1), DeleteRule.deleteRuleName((int)2), DeleteRule.deleteRuleName((int)3)};
    protected ProjectController mediator;
    protected CayenneTable table;
    private TableColumnPreferences tablePreferences;
    private ActionListener resolver;
    private ObjEntityAttributeRelationshipTab parentPanel;
    private boolean enabledResolve;
    protected JMenuItem resolveMenu;

    public ObjEntityRelationshipPanel(ProjectController mediator, ObjEntityAttributeRelationshipTab parentPanel) {
        this.mediator = mediator;
        this.parentPanel = parentPanel;
        this.init();
        this.initController();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        ActionManager actionManager = Application.getInstance().getActionManager();
        this.table = new CayenneTable();
        this.table.setDefaultRenderer(String.class, new StringRenderer());
        this.table.setDefaultRenderer(ObjEntity.class, new EntityRenderer());
        this.tablePreferences = new TableColumnPreferences(ObjRelationshipTableModel.class, "objEntity/relationshipTable");
        ImageIcon ico = ModelerUtil.buildIcon("icon-info.gif");
        this.resolveMenu = new JMenuItem("Database Mapping", ico);
        JPopupMenu popup = new JPopupMenu();
        popup.add(this.resolveMenu);
        popup.add(actionManager.getAction(RemoveAttributeRelationshipAction.class).buildMenu());
        popup.addSeparator();
        popup.add(actionManager.getAction(CutAttributeRelationshipAction.class).buildMenu());
        popup.add(actionManager.getAction(CopyAttributeRelationshipAction.class).buildMenu());
        popup.add(actionManager.getAction(PasteAction.class).buildMenu());
        TablePopupHandler.install(this.table, popup);
        this.add((Component)PanelFactory.createTablePanel(this.table, null), "Center");
    }

    private void initController() {
        this.mediator.addObjEntityDisplayListener(this);
        this.mediator.addObjEntityListener(this);
        this.mediator.addObjRelationshipListener(this);
        this.resolver = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ObjEntityRelationshipPanel.this.table.getSelectedRow();
                if (row < 0) {
                    return;
                }
                ObjRelationshipTableModel model = (ObjRelationshipTableModel)ObjEntityRelationshipPanel.this.table.getModel();
                new ObjRelationshipInfo(ObjEntityRelationshipPanel.this.mediator, model.getRelationship(row)).startupAction();
                ObjEntityRelationshipPanel.this.table.cancelEditing();
                ObjEntityRelationshipPanel.this.table.getSelectionModel().clearSelection();
                ObjEntityRelationshipPanel.this.table.select(row);
                ObjEntityRelationshipPanel.this.enabledResolve = false;
            }
        };
        this.resolveMenu.addActionListener(this.resolver);
        this.table.getSelectionModel().addListSelectionListener(new ObjRelationshipListSelectionListener());
        this.mediator.getApplication().getActionManager().setupCutCopyPaste(this.table, CutAttributeRelationshipAction.class, CopyAttributeRelationshipAction.class);
    }

    public void selectRelationships(ObjRelationship[] rels) {
        ObjRelationshipTableModel model = (ObjRelationshipTableModel)this.table.getModel();
        List listRels = model.getObjectList();
        int[] newSel = new int[rels.length];
        this.parentPanel.updateActions(rels);
        for (int i = 0; i < rels.length; ++i) {
            newSel[i] = listRels.indexOf(rels[i]);
        }
        this.table.select(newSel);
    }

    @Override
    public void currentObjEntityChanged(EntityDisplayEvent e) {
        if (e.getSource() == this) {
            return;
        }
        ObjEntity entity = (ObjEntity)e.getEntity();
        if (entity != null) {
            this.rebuildTable(entity);
        }
        if (e.isUnselectAttributes()) {
            this.table.clearSelection();
        }
    }

    private Object[] createObjEntityComboModel() {
        DataMap map = this.mediator.getCurrentDataMap();
        if (map == null) {
            logObj.warn((Object)"createObjEntityComboModel:: Null DataMap.");
            return new Object[0];
        }
        if (map.getNamespace() == null) {
            logObj.warn((Object)("createObjEntityComboModel:: Null DataMap namespace - " + map));
            return new Object[0];
        }
        Collection objEntities = map.getNamespace().getObjEntities();
        return objEntities.toArray();
    }

    public void objEntityChanged(EntityEvent e) {
    }

    public void objEntityAdded(EntityEvent e) {
        this.reloadEntityList(e);
    }

    public void objEntityRemoved(EntityEvent e) {
        this.reloadEntityList(e);
    }

    public void objRelationshipChanged(RelationshipEvent e) {
        this.table.select(e.getRelationship());
    }

    public void objRelationshipAdded(RelationshipEvent e) {
        this.rebuildTable((ObjEntity)e.getEntity());
        this.table.select(e.getRelationship());
    }

    public void objRelationshipRemoved(RelationshipEvent e) {
        ObjRelationshipTableModel model = (ObjRelationshipTableModel)this.table.getModel();
        int ind = model.getObjectList().indexOf(e.getRelationship());
        model.removeRow(e.getRelationship());
        this.table.select(ind);
    }

    private void reloadEntityList(EntityEvent e) {
        if (e.getSource() != this) {
            return;
        }
        ObjEntity entity = this.mediator.getCurrentObjEntity();
        if (entity == e.getEntity() || entity == null) {
            return;
        }
        TableColumn col = this.table.getColumnModel().getColumn(1);
        DefaultCellEditor editor = (DefaultCellEditor)col.getCellEditor();
        JComboBox combo = (JComboBox)editor.getComponent();
        combo.setRenderer(CellRenderers.entityListRendererWithIcons((MappingNamespace)entity.getDataMap()));
        combo.setModel(new DefaultComboBoxModel<Object>(this.createObjEntityComboModel()));
        ObjRelationshipTableModel model = (ObjRelationshipTableModel)this.table.getModel();
        model.fireTableDataChanged();
    }

    protected void rebuildTable(ObjEntity entity) {
        final ObjRelationshipTableModel model = new ObjRelationshipTableModel(entity, this.mediator, this);
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (ObjEntityRelationshipPanel.this.table.getSelectedRow() >= 0) {
                    ObjRelationship rel = model.getRelationship(ObjEntityRelationshipPanel.this.table.getSelectedRow());
                    if (rel.getSourceEntity().getDbEntity() != null) {
                        ObjEntityRelationshipPanel.this.enabledResolve = true;
                    } else {
                        ObjEntityRelationshipPanel.this.enabledResolve = false;
                    }
                    ObjEntityRelationshipPanel.this.resolveMenu.setEnabled(ObjEntityRelationshipPanel.this.enabledResolve);
                }
            }
        });
        this.table.setModel(model);
        this.table.setRowHeight(25);
        this.table.setRowMargin(3);
        TableColumn col = this.table.getColumnModel().getColumn(1);
        JComboBox targetCombo = Application.getWidgetFactory().createComboBox(this.createObjEntityComboModel(), false);
        AutoCompletion.enable(targetCombo);
        targetCombo.setRenderer(CellRenderers.entityListRendererWithIcons((MappingNamespace)entity.getDataMap()));
        targetCombo.setSelectedIndex(-1);
        col.setCellEditor(Application.getWidgetFactory().createCellEditor(targetCombo));
        col = this.table.getColumnModel().getColumn(3);
        JComboBox deleteRulesCombo = Application.getWidgetFactory().createComboBox(deleteRules, false);
        deleteRulesCombo.setEditable(false);
        deleteRulesCombo.setSelectedIndex(0);
        col.setCellEditor(Application.getWidgetFactory().createCellEditor(deleteRulesCombo));
        this.tablePreferences.bind(this.table, null, null, null, 0, true);
    }

    public boolean isEnabledResolve() {
        return this.enabledResolve;
    }

    public ActionListener getResolver() {
        return this.resolver;
    }

    private class ObjRelationshipListSelectionListener
    implements ListSelectionListener {
        private ObjRelationshipListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Object[] rels = new ObjRelationship[]{};
            if (!e.getValueIsAdjusting() && !((ListSelectionModel)e.getSource()).isSelectionEmpty()) {
                ((ObjEntityRelationshipPanel)ObjEntityRelationshipPanel.this).parentPanel.getAttributePanel().table.getSelectionModel().clearSelection();
                if (((ObjEntityRelationshipPanel)ObjEntityRelationshipPanel.this).parentPanel.getAttributePanel().table.getCellEditor() != null) {
                    ((ObjEntityRelationshipPanel)ObjEntityRelationshipPanel.this).parentPanel.getAttributePanel().table.getCellEditor().stopCellEditing();
                }
                Application.getInstance().getActionManager().getAction(RemoveAttributeRelationshipAction.class).setCurrentSelectedPanel(ObjEntityRelationshipPanel.this.parentPanel.getRelationshipPanel());
                Application.getInstance().getActionManager().getAction(CutAttributeRelationshipAction.class).setCurrentSelectedPanel(ObjEntityRelationshipPanel.this.parentPanel.getRelationshipPanel());
                Application.getInstance().getActionManager().getAction(CopyAttributeRelationshipAction.class).setCurrentSelectedPanel(ObjEntityRelationshipPanel.this.parentPanel.getRelationshipPanel());
                ObjEntityRelationshipPanel.this.parentPanel.getResolve().removeActionListener(ObjEntityRelationshipPanel.this.parentPanel.getAttributePanel().getResolver());
                ObjEntityRelationshipPanel.this.parentPanel.getResolve().removeActionListener(ObjEntityRelationshipPanel.this.getResolver());
                ObjEntityRelationshipPanel.this.parentPanel.getResolve().addActionListener(ObjEntityRelationshipPanel.this.getResolver());
                ObjEntityRelationshipPanel.this.parentPanel.getResolve().setToolTipText("Edit Relationship");
                ObjEntityRelationshipPanel.this.parentPanel.getResolve().setEnabled(true);
                if (ObjEntityRelationshipPanel.this.table.getSelectedRow() >= 0) {
                    ObjRelationshipTableModel model = (ObjRelationshipTableModel)ObjEntityRelationshipPanel.this.table.getModel();
                    int[] sel = ObjEntityRelationshipPanel.this.table.getSelectedRows();
                    rels = new ObjRelationship[sel.length];
                    for (int i = 0; i < sel.length; ++i) {
                        rels[i] = model.getRelationship(sel[i]);
                    }
                    if (sel.length == 1) {
                        UIUtil.scrollToSelectedRow(ObjEntityRelationshipPanel.this.table);
                    }
                    ObjEntityRelationshipPanel.this.enabledResolve = true;
                } else {
                    ObjEntityRelationshipPanel.this.enabledResolve = false;
                }
                ObjEntityRelationshipPanel.this.resolveMenu.setEnabled(ObjEntityRelationshipPanel.this.enabledResolve);
            }
            ObjEntityRelationshipPanel.this.mediator.setCurrentObjRelationships((ObjRelationship[])rels);
            ObjEntityRelationshipPanel.this.parentPanel.updateActions(rels);
        }
    }

    class StringRenderer
    extends DefaultTableCellRenderer {
        StringRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int align = column == 2 ? 0 : 2;
            super.setHorizontalAlignment(align);
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ObjRelationshipTableModel model = (ObjRelationshipTableModel)table.getModel();
            ObjRelationship relationship = model.getRelationship(row);
            if (relationship != null && relationship.getSourceEntity() != model.getEntity()) {
                this.setForeground(Color.GRAY);
            } else {
                this.setForeground(isSelected && !hasFocus ? table.getSelectionForeground() : table.getForeground());
            }
            return this;
        }
    }

    class EntityRenderer
    extends StringRenderer {
        EntityRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object oldValue = value;
            value = CellRenderers.asString(value);
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setIcon(CellRenderers.iconForObject(oldValue));
            return this;
        }
    }
}

