/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.SelectPropertiesPanel;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.query.Query;

public abstract class RawQueryPropertiesPanel
extends SelectPropertiesPanel {
    protected JCheckBox dataObjects;
    protected JComboBox entities;

    public RawQueryPropertiesPanel(ProjectController mediator) {
        super(mediator);
    }

    @Override
    protected void initController() {
        super.initController();
        this.dataObjects.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RawQueryPropertiesPanel.this.setFetchingDataObjects(RawQueryPropertiesPanel.this.dataObjects.isSelected());
            }
        });
        this.entities.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ObjEntity entity = (ObjEntity)RawQueryPropertiesPanel.this.entities.getModel().getSelectedItem();
                RawQueryPropertiesPanel.this.setEntity(entity);
            }
        });
    }

    protected PanelBuilder createPanelBuilder() {
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("right:max(80dlu;pref), 3dlu, left:max(10dlu;pref), 3dlu, left:max(37dlu;pref), 3dlu, fill:max(147dlu;pref)", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.addSeparator("Select Properties", cc.xywh(1, 1, 7, 1));
        builder.addLabel("Result Caching:", cc.xy(1, 3));
        builder.add((Component)this.cacheStrategy, cc.xywh(3, 3, 5, 1));
        this.cacheGroupsLabel = builder.addLabel("Cache Groups:", cc.xy(1, 7));
        builder.add((Component)this.cacheGroups.getComponent(), cc.xywh(3, 7, 5, 1));
        builder.addLabel("Fetch Data Objects:", cc.xy(1, 9));
        builder.add((Component)this.dataObjects, cc.xy(3, 9));
        builder.add((Component)this.entities, cc.xywh(5, 9, 3, 1));
        builder.addLabel("Fetch Offset, Rows:", cc.xy(1, 11));
        builder.add((Component)this.fetchOffset.getComponent(), cc.xywh(3, 11, 3, 1));
        builder.addLabel("Fetch Limit, Rows:", cc.xy(1, 13));
        builder.add((Component)this.fetchLimit.getComponent(), cc.xywh(3, 13, 3, 1));
        builder.addLabel("Page Size:", cc.xy(1, 15));
        builder.add((Component)this.pageSize.getComponent(), cc.xywh(3, 15, 3, 1));
        return builder;
    }

    @Override
    protected void initView() {
        super.initView();
        this.dataObjects = new JCheckBox();
        this.entities = Application.getWidgetFactory().createUndoableComboBox();
        this.entities.setRenderer(CellRenderers.listRendererWithIcons());
        this.setLayout(new BorderLayout());
        this.add((Component)this.createPanelBuilder().getPanel(), "Center");
    }

    @Override
    public void initFromModel(Query query) {
        super.initFromModel(query);
        EntityResolver entRes = new EntityResolver(((DataChannelDescriptor)this.mediator.getProject().getRootNode()).getDataMaps());
        boolean fetchingDO = !query.getMetaData(entRes).isFetchingDataRows();
        this.dataObjects.setSelected(fetchingDO);
        DataMap map = this.mediator.getCurrentDataMap();
        ArrayList objEntities = new ArrayList();
        objEntities.addAll(map.getObjEntities());
        if (objEntities.size() > 1) {
            Collections.sort(objEntities, Comparators.getDataMapChildrenComparator());
        }
        this.entities.setEnabled(fetchingDO && this.isEnabled());
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(objEntities.toArray());
        model.setSelectedItem(this.getEntity(query));
        this.entities.setModel(model);
    }

    protected abstract void setEntity(ObjEntity var1);

    protected abstract ObjEntity getEntity(Query var1);

    protected void setFetchingDataObjects(boolean dataObjects) {
        this.entities.setEnabled(dataObjects && this.isEnabled());
        if (!dataObjects) {
            this.entities.getModel().setSelectedItem(null);
        }
        this.setQueryProperty("fetchingDataRows", dataObjects ? Boolean.FALSE : Boolean.TRUE);
    }
}

