/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.datanode;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.event.DataNodeEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.datanode.AdapterView;
import org.apache.cayenne.modeler.event.DataNodeDisplayEvent;
import org.apache.cayenne.modeler.event.DataNodeDisplayListener;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.ObjectBinding;

public class AdapterEditor
extends CayenneController {
    protected AdapterView view = new AdapterView();
    protected DataNodeDescriptor node;
    protected ObjectBinding adapterNameBinding;

    public AdapterEditor(CayenneController parent) {
        super(parent);
        this.initController();
    }

    protected void initController() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        this.adapterNameBinding = builder.bindToTextField(this.view.getCustomAdapter(), "adapterName");
        ((ProjectController)this.getParent()).addDataNodeDisplayListener(new DataNodeDisplayListener(){

            @Override
            public void currentDataNodeChanged(DataNodeDisplayEvent e) {
                AdapterEditor.this.refreshView(e.getDataNode());
            }
        });
        this.getView().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                AdapterEditor.this.refreshView(AdapterEditor.this.node != null ? AdapterEditor.this.node : ((ProjectController)AdapterEditor.this.getParent()).getCurrentDataNode());
            }
        });
    }

    protected void refreshView(DataNodeDescriptor dataNodeDescriptor) {
        this.node = dataNodeDescriptor;
        if (dataNodeDescriptor == null) {
            this.getView().setVisible(false);
            return;
        }
        this.adapterNameBinding.updateView();
    }

    @Override
    public Component getView() {
        return this.view;
    }

    public String getAdapterName() {
        if (this.node == null) {
            return null;
        }
        return this.node.getAdapterType();
    }

    public void setAdapterName(String name) {
        if (this.node == null) {
            return;
        }
        this.node.setAdapterType(name);
        DataNodeEvent e = new DataNodeEvent(this, this.node);
        ((ProjectController)this.getParent()).fireDataNodeEvent(e);
    }
}

