/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.datanode;

import java.awt.Component;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.modeler.CayenneModelerController;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.datanode.DataSourceEditor;
import org.apache.cayenne.modeler.editor.datanode.JDBCDataSourceView;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.BindingDelegate;
import org.apache.cayenne.swing.ObjectBinding;
import org.apache.cayenne.util.Util;

public class JDBCDataSourceEditor
extends DataSourceEditor {
    protected JDBCDataSourceView view;

    public JDBCDataSourceEditor(ProjectController parent, BindingDelegate nodeChangeProcessor) {
        super(parent, nodeChangeProcessor);
    }

    @Override
    public Component getView() {
        return this.view;
    }

    @Override
    public void setNode(DataNodeDescriptor node) {
        if (!Util.nullSafeEquals((Object)this.getNode(), (Object)node)) {
            if (node.getDataSourceDescriptor() == null) {
                node.setDataSourceDescriptor(new DataSourceInfo());
            }
            super.setNode(node);
        }
    }

    @Override
    protected void prepareBindings(BindingBuilder builder) {
        this.view = new JDBCDataSourceView();
        this.fieldAdapters = new ObjectBinding[6];
        this.fieldAdapters[0] = builder.bindToTextField(this.view.getUserName(), "node.dataSourceDescriptor.userName");
        this.fieldAdapters[1] = builder.bindToTextField(this.view.getPassword(), "node.dataSourceDescriptor.password");
        this.fieldAdapters[2] = builder.bindToTextField(this.view.getUrl(), "node.dataSourceDescriptor.dataSourceUrl");
        this.fieldAdapters[3] = builder.bindToTextField(this.view.getDriver(), "node.dataSourceDescriptor.jdbcDriver");
        this.fieldAdapters[4] = builder.bindToTextField(this.view.getMaxConnections(), "node.dataSourceDescriptor.maxConnections");
        this.fieldAdapters[5] = builder.bindToTextField(this.view.getMinConnections(), "node.dataSourceDescriptor.minConnections");
        builder.bindToAction(this.view.getSyncWithLocal(), "syncDataSourceAction()");
    }

    public void syncDataSourceAction() {
        CayenneModelerController mainController = this.getApplication().getFrameController();
        if (this.getNode() == null || this.getNode().getDataSourceDescriptor() == null) {
            return;
        }
        DataSourceInfo projectDSI = this.getNode().getDataSourceDescriptor();
        ProjectController parent = (ProjectController)this.getParent();
        String key = parent.getDataNodePreferences().getLocalDataSource();
        if (key == null) {
            mainController.updateStatus("No Local DataSource selected for node...");
            return;
        }
        DBConnectionInfo dataSource = (DBConnectionInfo)this.getApplication().getCayenneProjectPreferences().getDetailObject(DBConnectionInfo.class).getObject(key);
        if (dataSource != null) {
            if (dataSource.copyTo(projectDSI)) {
                this.refreshView();
                this.nodeChangeProcessor.modelUpdated(null, null, null);
                mainController.updateStatus(null);
            } else {
                mainController.updateStatus("DataNode is up to date...");
            }
        } else {
            mainController.updateStatus("Invalid Local DataSource selected for node...");
        }
    }
}

