/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbentity;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.event.DbEntityListener;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.CopyAttributeRelationshipAction;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.CreateObjEntityAction;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.action.CutAttributeRelationshipAction;
import org.apache.cayenne.modeler.action.DbEntityCounterpartAction;
import org.apache.cayenne.modeler.action.DbEntitySyncAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.RemoveAttributeRelationshipAction;
import org.apache.cayenne.modeler.editor.dbentity.DbEntityAttributePanel;
import org.apache.cayenne.modeler.editor.dbentity.DbEntityRelationshipPanel;
import org.apache.cayenne.modeler.event.DbEntityDisplayListener;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.util.ModelerUtil;

public class DbEntityAttributeRelationshipTab
extends JPanel
implements DbEntityDisplayListener,
DbEntityListener {
    public DbEntityAttributePanel attributePanel;
    public DbEntityRelationshipPanel relationshipPanel;
    public JButton resolve = new JButton();
    private JSplitPane splitPane;
    private ProjectController mediator;
    private CutAttributeRelationshipAction cut;
    private RemoveAttributeRelationshipAction remove;
    private CopyAttributeRelationshipAction copy;

    public DbEntityAttributeRelationshipTab(ProjectController mediator) {
        this.mediator = mediator;
        this.init();
        this.initToolBar();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.attributePanel = new DbEntityAttributePanel(this.mediator, this);
        this.relationshipPanel = new DbEntityRelationshipPanel(this.mediator, this);
        this.splitPane = new JSplitPane(0, this.attributePanel, this.relationshipPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setResizeWeight(0.5);
        this.add(this.splitPane);
    }

    private void initToolBar() {
        JToolBar toolBar = new JToolBar();
        ActionManager actionManager = Application.getInstance().getActionManager();
        toolBar.add(actionManager.getAction(CreateObjEntityAction.class).buildButton());
        toolBar.add(actionManager.getAction(CreateAttributeAction.class).buildButton());
        toolBar.add(actionManager.getAction(CreateRelationshipAction.class).buildButton());
        toolBar.add(actionManager.getAction(DbEntitySyncAction.class).buildButton());
        toolBar.add(actionManager.getAction(DbEntityCounterpartAction.class).buildButton());
        toolBar.addSeparator();
        ImageIcon ico = ModelerUtil.buildIcon("icon-info.gif");
        this.resolve.setToolTipText("Database Mapping");
        this.resolve.setIcon(ico);
        toolBar.add(this.resolve).setEnabled(false);
        this.cut = actionManager.getAction(CutAttributeRelationshipAction.class);
        this.remove = actionManager.getAction(RemoveAttributeRelationshipAction.class);
        this.copy = actionManager.getAction(CopyAttributeRelationshipAction.class);
        toolBar.addSeparator();
        toolBar.add(this.remove.buildButton());
        toolBar.addSeparator();
        toolBar.add(this.cut.buildButton());
        toolBar.add(this.copy.buildButton());
        toolBar.add(actionManager.getAction(PasteAction.class).buildButton());
        this.add((Component)toolBar, "North");
    }

    public void updateActions(Object[] params) {
        ModelerUtil.updateActions(params.length, RemoveAttributeRelationshipAction.class, CutAttributeRelationshipAction.class, CopyAttributeRelationshipAction.class);
        if (params instanceof DbRelationship[]) {
            this.resolve.setEnabled(params.length > 0);
        }
    }

    public JButton getResolve() {
        return this.resolve;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public DbEntityAttributePanel getAttributePanel() {
        return this.attributePanel;
    }

    public DbEntityRelationshipPanel getRelationshipPanel() {
        return this.relationshipPanel;
    }

    public void dbEntityChanged(EntityEvent e) {
        this.relationshipPanel.dbEntityChanged(e);
    }

    public void dbEntityAdded(EntityEvent e) {
        this.relationshipPanel.dbEntityAdded(e);
    }

    public void dbEntityRemoved(EntityEvent e) {
        this.relationshipPanel.dbEntityRemoved(e);
    }

    @Override
    public void currentDbEntityChanged(EntityDisplayEvent e) {
        this.attributePanel.currentDbEntityChanged(e);
        this.relationshipPanel.currentDbEntityChanged(e);
    }
}

