/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.graph;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.organic.JGraphOrganicLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.event.DataMapEvent;
import org.apache.cayenne.configuration.event.DataMapListener;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.graph.EntityCellMetadata;
import org.apache.cayenne.modeler.graph.GraphBuilder;
import org.apache.cayenne.modeler.graph.action.EntityDisplayAction;
import org.apache.cayenne.modeler.graph.action.RemoveEntityAction;
import org.apache.cayenne.util.XMLEncoder;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;

abstract class BaseGraphBuilder
implements GraphBuilder,
DataMapListener {
    static final Font EDGE_FONT = new Font("Verdana", 0, 10);
    protected JGraph graph;
    protected transient DataChannelDescriptor domain;
    protected Map<String, DefaultGraphCell> entityCells;
    protected Map<String, DefaultEdge> relCells;
    protected List<DefaultGraphCell> createdObjects;
    protected transient ProjectController mediator;
    protected transient Entity selectedEntity;
    transient JPopupMenu popup;
    boolean undoEventsDisabled;

    BaseGraphBuilder() {
    }

    @Override
    public void buildGraph(ProjectController mediator, DataChannelDescriptor domain, boolean doLayout) {
        if (this.graph != null) {
            return;
        }
        this.graph = new JGraph();
        DefaultGraphModel model = new DefaultGraphModel();
        this.graph.setModel((GraphModel)model);
        this.setProjectController(mediator);
        this.setDataDomain(domain);
        GraphLayoutCache view = new GraphLayoutCache((GraphModel)model, (CellViewFactory)new DefaultCellViewFactory());
        this.graph.setGraphLayoutCache(view);
        this.graph.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Object userObject;
                Object selected;
                if (e.isPopupTrigger() && (selected = BaseGraphBuilder.this.graph.getSelectionCell()) != null && selected instanceof DefaultGraphCell && (userObject = ((DefaultGraphCell)selected).getUserObject()) instanceof EntityCellMetadata) {
                    BaseGraphBuilder.this.showPopup(e.getPoint(), ((EntityCellMetadata)userObject).fetchEntity());
                }
            }
        });
        this.graph.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                BaseGraphBuilder.this.graph.setScale(BaseGraphBuilder.this.graph.getScale() / Math.pow(1.3, e.getWheelRotation()));
            }
        });
        this.entityCells = new HashMap<String, DefaultGraphCell>();
        this.createdObjects = new ArrayList<DefaultGraphCell>();
        this.relCells = new HashMap<String, DefaultEdge>();
        ArrayList isolatedObjects = new ArrayList();
        for (DataMap map : domain.getDataMaps()) {
            DefaultGraphCell mapCell = new DefaultGraphCell();
            this.createdObjects.add(mapCell);
            for (Entity entity : this.getEntities(map)) {
                DefaultGraphCell cell = this.createEntityCell(entity);
                List<Object> array = !this.isIsolated(domain, entity) ? this.createdObjects : isolatedObjects;
                array.add(cell);
                array.add((DefaultGraphCell)cell.getChildAt(0));
            }
        }
        for (DataMap map : domain.getDataMaps()) {
            for (Entity entity : this.getEntities(map)) {
                DefaultGraphCell defaultGraphCell = this.entityCells.get(entity.getName());
                this.postProcessEntity(entity, defaultGraphCell);
            }
        }
        view.insert(this.createdObjects.toArray());
        if (doLayout) {
            JGraphFacade facade = new JGraphFacade(this.graph);
            JGraphOrganicLayout layout = new JGraphOrganicLayout();
            layout.setNodeDistributionCostFactor(5.0E12);
            layout.setEdgeLengthCostFactor(1000.0);
            layout.setEdgeCrossingCostFactor(1000000.0);
            layout.setOptimizeBorderLine(false);
            layout.setOptimizeEdgeDistance(false);
            layout.run(facade);
            Map nested = facade.createNestedMap(true, true);
            this.edit(nested);
        }
        if (isolatedObjects.size() > 0) {
            int n = isolatedObjects.size() / 2;
            int x = (int)Math.ceil((Math.sqrt(1 + 8 * n) - 1.0) / 2.0);
            Dimension pref = this.graph.getPreferredSize();
            int n2 = pref.width / 2 / x;
            int n3 = pref.height / 2 / x;
            int posX = n2 / 2;
            int posY = n3 / 2;
            int row = 0;
            int isolatedIndex = 0;
            while (isolatedIndex < isolatedObjects.size()) {
                for (int i = 0; isolatedIndex < isolatedObjects.size() && i < x - row; ++i) {
                    GraphConstants.setBounds((Map)((DefaultGraphCell)isolatedObjects.get(isolatedIndex)).getAttributes(), (Rectangle2D)new Rectangle2D.Double(pref.width - posX, pref.height - 3 * posY / 2, 10.0, 10.0));
                    isolatedIndex += 2;
                    posX += n2;
                }
                posX = n2 / 2;
                posY += n3 / 2;
                ++row;
            }
        }
        view.insert(isolatedObjects.toArray());
        this.graph.getModel().addUndoableEditListener((UndoableEditListener)this);
    }

    protected DefaultGraphCell createEntityCell(Entity entity) {
        DefaultGraphCell cell = new DefaultGraphCell((Object)this.getCellMetadata(entity));
        GraphConstants.setResize((Map)cell.getAttributes(), (boolean)true);
        GraphConstants.setBorder((Map)cell.getAttributes(), (Border)new LineBorder(Color.BLACK));
        GraphConstants.setEditable((Map)cell.getAttributes(), (boolean)false);
        this.entityCells.put(entity.getName(), cell);
        cell.addPort();
        return cell;
    }

    @Override
    public DefaultGraphCell getEntityCell(String entityName) {
        return this.entityCells.get(entityName);
    }

    protected void postProcessEntity(Entity entity, DefaultGraphCell cell) {
        for (Relationship rel : entity.getRelationships()) {
            DefaultEdge edge;
            if (rel.getSourceEntity() == null || rel.getTargetEntity() == null || (edge = this.createRelationshipCell(rel)) == null) continue;
            this.createdObjects.add((DefaultGraphCell)edge);
        }
    }

    protected boolean isIsolated(DataChannelDescriptor domain, Entity entity) {
        if (entity.getRelationships().size() == 0) {
            for (DataMap map : domain.getDataMaps()) {
                for (Entity entity2 : this.getEntities(map)) {
                    if (entity2.getAnyRelationship(entity) == null) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected abstract Collection<? extends Entity> getEntities(DataMap var1);

    private static String getRelationshipLabel(Relationship rel) {
        if (rel == null) {
            return null;
        }
        if (rel.isToMany()) {
            return "0..*";
        }
        return rel.isMandatory() ? "1" : "0..1";
    }

    protected abstract EntityCellMetadata getCellMetadata(Entity var1);

    protected void showPopup(Point p, Entity entity) {
        this.selectedEntity = entity;
        if (this.popup == null) {
            this.popup = this.createPopupMenu();
        }
        this.popup.show((Component)this.graph, p.x, p.y);
    }

    @Override
    public Entity getSelectedEntity() {
        return this.selectedEntity;
    }

    protected JPopupMenu createPopupMenu() {
        ActionManager actionManager = Application.getInstance().getActionManager();
        JPopupMenu menu = new JPopupMenu();
        menu.add(new EntityDisplayAction(this).buildMenu());
        menu.addSeparator();
        menu.add(new EntityDisplayAction(this, actionManager.getAction(CreateAttributeAction.class)).buildMenu());
        menu.add(new EntityDisplayAction(this, actionManager.getAction(CreateRelationshipAction.class)).buildMenu());
        menu.addSeparator();
        menu.add(new RemoveEntityAction(this));
        return menu;
    }

    protected void updateEntityCell(Entity e) {
        DefaultGraphCell cell = this.entityCells.get(e.getName());
        if (cell != null) {
            GraphConstants.setValue((Map)cell.getAttributes(), (Object)this.getCellMetadata(e));
            GraphConstants.setResize((Map)cell.getAttributes(), (boolean)true);
            HashMap<DefaultGraphCell, AttributeMap> nested = new HashMap<DefaultGraphCell, AttributeMap>();
            nested.put(cell, cell.getAttributes());
            this.edit(nested);
        }
    }

    protected void updateRelationshipCell(Relationship rel) {
        if (rel.getSourceEntity() != null && rel.getTargetEntity() != null) {
            DefaultEdge edge = this.relCells.get(BaseGraphBuilder.getQualifiedName(rel));
            if (edge != null) {
                this.updateRelationshipLabels(edge, rel, rel.getReverseRelationship());
                HashMap<DefaultEdge, AttributeMap> nested = new HashMap<DefaultEdge, AttributeMap>();
                nested.put(edge, edge.getAttributes());
                this.edit(nested);
            } else {
                this.insertRelationshipCell(rel);
            }
        }
    }

    protected void removeEntityCell(Entity e) {
        final DefaultGraphCell cell = this.entityCells.get(e.getName());
        if (cell != null) {
            this.runWithUndoDisabled(new Runnable(){

                @Override
                public void run() {
                    BaseGraphBuilder.this.graph.getGraphLayoutCache().remove(new Object[]{cell}, true, true);
                }
            });
            this.entityCells.remove(e.getName());
        }
    }

    protected void removeRelationshipCell(Relationship rel) {
        final DefaultEdge edge = this.relCells.get(BaseGraphBuilder.getQualifiedName(rel));
        if (edge != null) {
            this.runWithUndoDisabled(new Runnable(){

                @Override
                public void run() {
                    BaseGraphBuilder.this.graph.getGraphLayoutCache().remove(new Object[]{edge});
                }
            });
            this.relCells.remove(BaseGraphBuilder.getQualifiedName(rel));
        }
    }

    protected DefaultEdge createRelationshipCell(Relationship rel) {
        if (!this.relCells.containsKey(BaseGraphBuilder.getQualifiedName(rel))) {
            Relationship reverse = rel.getReverseRelationship();
            DefaultEdge edge = new DefaultEdge();
            GraphConstants.setEditable((Map)edge.getAttributes(), (boolean)false);
            GraphConstants.setLabelAlongEdge((Map)edge.getAttributes(), (boolean)true);
            GraphConstants.setSelectable((Map)edge.getAttributes(), (boolean)false);
            GraphConstants.setFont((Map)edge.getAttributes(), (Font)EDGE_FONT);
            this.updateRelationshipLabels(edge, rel, reverse);
            this.relCells.put(BaseGraphBuilder.getQualifiedName(rel), edge);
            if (reverse != null) {
                this.relCells.put(BaseGraphBuilder.getQualifiedName(reverse), edge);
            }
            return edge;
        }
        return null;
    }

    protected void insertRelationshipCell(Relationship rel) {
        DefaultEdge edge = this.createRelationshipCell(rel);
        this.insert(edge);
    }

    protected void insertEntityCell(Entity entity) {
        DefaultGraphCell cell = this.createEntityCell(entity);
        GraphConstants.setBounds((Map)cell.getAttributes(), (Rectangle2D)new Rectangle2D.Double(Math.random() * (double)this.graph.getWidth(), Math.random() * (double)this.graph.getHeight(), 10.0, 10.0));
        this.postProcessEntity(entity, cell);
        this.insert(cell);
    }

    protected void updateRelationshipLabels(DefaultEdge edge, Relationship rel, Relationship reverse) {
        DefaultGraphCell sourceCell = this.entityCells.get(rel.getSourceEntity().getName());
        DefaultGraphCell targetCell = this.entityCells.get(rel.getTargetEntity().getName());
        edge.setSource(sourceCell != null ? sourceCell.getChildAt(0) : null);
        edge.setTarget(targetCell != null ? targetCell.getChildAt(0) : null);
        Object[] labels = new Object[]{rel.getName() + " " + BaseGraphBuilder.getRelationshipLabel(rel), reverse == null ? "" : reverse.getName() + " " + BaseGraphBuilder.getRelationshipLabel(reverse)};
        GraphConstants.setExtraLabels((Map)edge.getAttributes(), (Object[])labels);
        Point2D[] labelPositions = new Point2D[]{new Point2D.Double(1000.0 * (0.1 + 0.2 * Math.random()), 10.0), new Point2D.Double(1000.0 * (0.9 - 0.2 * Math.random()), -10.0)};
        GraphConstants.setExtraLabelPositions((Map)edge.getAttributes(), (Point2D[])labelPositions);
    }

    @Override
    public JGraph getGraph() {
        return this.graph;
    }

    @Override
    public void dataMapAdded(DataMapEvent e) {
    }

    @Override
    public void dataMapChanged(DataMapEvent e) {
    }

    @Override
    public void dataMapRemoved(DataMapEvent e) {
        for (Entity entity : this.getEntities(e.getDataMap())) {
            this.removeEntityCell(entity);
        }
    }

    public void setProjectController(ProjectController mediator) {
        this.mediator = mediator;
        mediator.addDataMapListener(this);
    }

    public void setDataDomain(DataChannelDescriptor domain) {
        this.domain = domain;
    }

    @Override
    public DataChannelDescriptor getDataDomain() {
        return this.domain;
    }

    @Override
    public void destroy() {
        this.mediator.removeDataMapListener(this);
    }

    protected void remapEntity(EntityEvent e) {
        if (e.isNameChange()) {
            this.entityCells.put(e.getNewName(), this.entityCells.remove(e.getOldName()));
        }
    }

    protected void remapRelationship(RelationshipEvent e) {
        if (e.isNameChange()) {
            this.relCells.put(BaseGraphBuilder.getQualifiedName(e.getRelationship()), this.relCells.remove(e.getEntity().getName() + "." + e.getOldName()));
        }
    }

    static String getQualifiedName(Relationship rel) {
        return rel.getSourceEntity().getName() + "." + rel.getName();
    }

    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<graph type=\"");
        encoder.print(this.getType().toString());
        encoder.print("\" scale=\"");
        encoder.print(String.valueOf(this.graph.getScale()));
        encoder.println("\">");
        encoder.indent(1);
        for (Map.Entry<String, DefaultGraphCell> entry : this.entityCells.entrySet()) {
            encoder.print("<entity name=\"");
            encoder.print(entry.getKey());
            encoder.print("\" ");
            DefaultGraphCell cell = entry.getValue();
            Rectangle2D rect = this.graph.getCellBounds((Object)cell);
            this.encodeRecangle(encoder, rect);
            encoder.println("/>");
        }
        encoder.indent(-1);
        encoder.println("</graph>");
    }

    private void encodeRecangle(XMLEncoder encoder, Rectangle2D rect) {
        encoder.print("x=\"");
        encoder.print(rect.getX() + "\" y=\"");
        encoder.print(rect.getY() + "\" width=\"");
        encoder.print(rect.getWidth() + "\" height=\"");
        encoder.print(rect.getHeight() + "\" ");
    }

    private void edit(final Map map) {
        this.runWithUndoDisabled(new Runnable(){

            @Override
            public void run() {
                BaseGraphBuilder.this.graph.getGraphLayoutCache().edit(map);
            }
        });
    }

    private void insert(final Object cell) {
        this.runWithUndoDisabled(new Runnable(){

            @Override
            public void run() {
                BaseGraphBuilder.this.graph.getGraphLayoutCache().insert(cell);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithUndoDisabled(Runnable r) {
        this.undoEventsDisabled = true;
        try {
            r.run();
        }
        finally {
            this.undoEventsDisabled = false;
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        if (!this.undoEventsDisabled) {
            this.mediator.setDirty(true);
            Application.getInstance().getUndoManager().undoableEditHappened(e);
        }
    }
}

