/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.graph;

import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.DbAttributeListener;
import org.apache.cayenne.map.event.DbEntityListener;
import org.apache.cayenne.map.event.DbRelationshipListener;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.graph.BaseGraphBuilder;
import org.apache.cayenne.modeler.graph.DbEntityCellMetadata;
import org.apache.cayenne.modeler.graph.EntityCellMetadata;
import org.apache.cayenne.modeler.graph.GraphType;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;

class DbGraphBuilder
extends BaseGraphBuilder
implements DbEntityListener,
DbAttributeListener,
DbRelationshipListener {
    static final Color ENTITY_COLOR = new Color(197, 253, 252);

    DbGraphBuilder() {
    }

    @Override
    protected Collection<? extends Entity> getEntities(DataMap map) {
        return map.getDbEntities();
    }

    @Override
    protected void postProcessEntity(Entity entity, DefaultGraphCell cell) {
        super.postProcessEntity(entity, cell);
        GraphConstants.setBackground((Map)cell.getAttributes(), (Color)ENTITY_COLOR);
        GraphConstants.setOpaque((Map)cell.getAttributes(), (boolean)true);
    }

    @Override
    protected EntityCellMetadata getCellMetadata(Entity e) {
        return new DbEntityCellMetadata(this, e.getName());
    }

    @Override
    protected DefaultEdge createRelationshipCell(Relationship rel) {
        DefaultEdge edge = super.createRelationshipCell(rel);
        if (edge != null) {
            GraphConstants.setDashPattern((Map)edge.getAttributes(), (float[])new float[]{10.0f, 3.0f});
        }
        return edge;
    }

    @Override
    public void setProjectController(ProjectController mediator) {
        super.setProjectController(mediator);
        mediator.addDbEntityListener(this);
        mediator.addDbAttributeListener(this);
        mediator.addDbRelationshipListener(this);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.mediator.removeDbEntityListener(this);
        this.mediator.removeDbAttributeListener(this);
        this.mediator.removeDbRelationshipListener(this);
    }

    public void dbEntityAdded(EntityEvent e) {
        this.insertEntityCell(e.getEntity());
    }

    public void dbEntityChanged(EntityEvent e) {
        this.remapEntity(e);
        this.updateEntityCell(e.getEntity());
    }

    public void dbEntityRemoved(EntityEvent e) {
        this.removeEntityCell(e.getEntity());
    }

    public void dbAttributeAdded(AttributeEvent e) {
        this.updateEntityCell(e.getEntity());
    }

    public void dbAttributeChanged(AttributeEvent e) {
        this.updateEntityCell(e.getEntity());
    }

    public void dbAttributeRemoved(AttributeEvent e) {
        this.updateEntityCell(e.getEntity());
    }

    public void dbRelationshipAdded(RelationshipEvent e) {
    }

    public void dbRelationshipChanged(RelationshipEvent e) {
        this.updateRelationshipCell(e.getRelationship());
    }

    public void dbRelationshipRemoved(RelationshipEvent e) {
        this.remapRelationship(e);
        this.removeRelationshipCell(e.getRelationship());
    }

    @Override
    public GraphType getType() {
        return GraphType.ER;
    }
}

