/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.graph;

import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import org.apache.cayenne.modeler.graph.GraphBuilder;
import org.apache.cayenne.modeler.graph.GraphMap;
import org.apache.cayenne.modeler.graph.GraphType;
import org.apache.cayenne.util.Util;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GraphLoader
extends DefaultHandler {
    static final String GRAPH_TAG = "graph";
    static final String ENTITY_TAG = "entity";
    GraphMap map;
    GraphBuilder builder;
    Map<DefaultGraphCell, Map<String, ?>> propertiesMap;

    public GraphLoader(GraphMap map) {
        this.map = map;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String name;
        DefaultGraphCell cell;
        if (GRAPH_TAG.equalsIgnoreCase(localName)) {
            String type = attributes.getValue("", "type");
            if (Util.isEmptyString((String)type)) {
                throw new SAXException("Graph type not specified");
            }
            GraphType graphType = GraphType.valueOf(type);
            if (graphType == null) {
                throw new SAXException("Graph type " + type + " not supported");
            }
            this.builder = this.map.createGraphBuilder(graphType, false);
            this.builder.getGraph().setScale(this.getAsDouble(attributes, "scale"));
            this.propertiesMap = new Hashtable();
        } else if (ENTITY_TAG.equalsIgnoreCase(localName) && (cell = this.builder.getEntityCell(name = attributes.getValue("", "name"))) != null) {
            Hashtable props = new Hashtable();
            GraphConstants.setBounds(props, (Rectangle2D)new Rectangle2D.Double(this.getAsDouble(attributes, "x"), this.getAsDouble(attributes, "y"), this.getAsDouble(attributes, "width"), this.getAsDouble(attributes, "height")));
            this.propertiesMap.put(cell, props);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (GRAPH_TAG.equalsIgnoreCase(localName)) {
            this.builder.getGraph().getGraphLayoutCache().getModel().removeUndoableEditListener((UndoableEditListener)this.builder);
            this.builder.getGraph().getGraphLayoutCache().edit(this.propertiesMap, null, null, new UndoableEdit[0]);
            this.builder.getGraph().getGraphLayoutCache().getModel().addUndoableEditListener((UndoableEditListener)this.builder);
        }
    }

    private double getAsDouble(Attributes atts, String key) {
        return Double.valueOf(atts.getValue("", key));
    }
}

