/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.graph.action;

import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.graph.DataDomainGraphTab;
import org.apache.cayenne.modeler.pref.FSPath;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.FileFilters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgraph.JGraph;

public class SaveAsImageAction
extends CayenneAction {
    private static final Log logObj = LogFactory.getLog(SaveAsImageAction.class);
    private final DataDomainGraphTab dataDomainGraphTab;

    public SaveAsImageAction(DataDomainGraphTab dataDomainGraphTab, Application application) {
        super("Save As Image", application);
        this.dataDomainGraphTab = dataDomainGraphTab;
        this.setEnabled(true);
    }

    @Override
    public String getIconName() {
        return "icon-save-as-image.png";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performAction(ActionEvent e) {
        FSPath lastDir = this.getApplication().getFrameController().getLastDirectory();
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        lastDir.updateChooser(chooser);
        chooser.setAcceptAllFileFilterUsed(false);
        String ext = "png";
        chooser.addChoosableFileFilter(FileFilters.getExtensionFileFilter(ext, "PNG Images"));
        int status = chooser.showSaveDialog(Application.getFrame());
        if (status == 0) {
            lastDir.updateFromChooser(chooser);
            String path = chooser.getSelectedFile().getPath();
            if (!path.endsWith("." + ext)) {
                path = path + "." + ext;
            }
            try {
                FileOutputStream out = new FileOutputStream(path);
                JGraph graph = this.dataDomainGraphTab.getGraph();
                BufferedImage img = graph.getImage(null, 0);
                try {
                    ImageIO.write((RenderedImage)img, ext, out);
                    out.flush();
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException ex) {
                logObj.error((Object)"Could not save image", (Throwable)ex);
                JOptionPane.showMessageDialog(Application.getFrame(), "Could not save image.", "Error saving image", 0);
            }
        }
    }
}

