/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.graph.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.CayenneModelerFrame;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.EditorView;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.util.CayenneAction;

public class ShowGraphEntityAction
extends CayenneAction {
    public static String getActionName() {
        return "ShowGraphEntity";
    }

    public ShowGraphEntityAction(Application application) {
        super(ShowGraphEntityAction.getActionName(), application, "Show on Graph");
        this.setEnabled(true);
    }

    @Override
    public String getIconName() {
        return "icon-save-as-image.png";
    }

    @Override
    public void performAction(ActionEvent e) {
        DbEntity entity = null;
        ProjectController mediator = this.getProjectController();
        if (mediator.getCurrentDbEntity() != null) {
            entity = mediator.getCurrentDbEntity();
        } else if (mediator.getCurrentObjEntity() != null) {
            entity = mediator.getCurrentObjEntity();
        }
        if (entity != null) {
            this.showEntity((Entity)entity);
        }
    }

    @Override
    public boolean enableForPath(ConfigurationNode object) {
        return object instanceof Entity;
    }

    void showEntity(Entity entity) {
        EditorView editor = ((CayenneModelerFrame)Application.getInstance().getFrameController().getView()).getView();
        editor.getProjectTreeView().getSelectionModel().setSelectionPath(editor.getProjectTreeView().getSelectionPath().getParentPath().getParentPath());
        EntityDisplayEvent event = new EntityDisplayEvent((Object)editor.getProjectTreeView(), entity, entity.getDataMap(), (DataChannelDescriptor)this.getProjectController().getProject().getRootNode());
        this.getProjectController().fireDomainDisplayEvent(event);
    }
}

