/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityListener;
import org.apache.cayenne.modeler.action.CreateDataMapEntityListenerAction;
import org.apache.cayenne.modeler.action.RemoveEntityListenerForDataMapAction;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class CreateDataMapEntityListenerUndoableEdit
extends CayenneUndoableEdit {
    private DataMap dataMap;
    private EntityListener listener;

    public CreateDataMapEntityListenerUndoableEdit(DataMap dataMap, EntityListener listener) {
        this.dataMap = dataMap;
        this.listener = listener;
    }

    @Override
    public String getPresentationName() {
        return "Create Entity Listener";
    }

    @Override
    public void redo() throws CannotRedoException {
        CreateDataMapEntityListenerAction action = this.actionManager.getAction(CreateDataMapEntityListenerAction.class);
        action.createMapListener(this.dataMap, this.listener);
    }

    @Override
    public void undo() throws CannotUndoException {
        RemoveEntityListenerForDataMapAction action = this.actionManager.getAction(RemoveEntityListenerForDataMapAction.class);
        action.removeEntityListener(this.dataMap, this.listener.getClassName());
    }
}

