/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.map.EntityListener;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.action.CreateDataMapEntityListenerAction;
import org.apache.cayenne.modeler.action.RemoveEntityListenerAction;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class CreateEntityListenerUndoableEdit
extends CayenneUndoableEdit {
    private ObjEntity objEntity;
    private EntityListener listener;

    public CreateEntityListenerUndoableEdit(ObjEntity objEntity, EntityListener listener) {
        this.objEntity = objEntity;
        this.listener = listener;
    }

    @Override
    public String getPresentationName() {
        return "Create Entity Listener";
    }

    @Override
    public void redo() throws CannotRedoException {
        CreateDataMapEntityListenerAction action = this.actionManager.getAction(CreateDataMapEntityListenerAction.class);
        action.createEntityListener(this.objEntity, this.listener);
    }

    @Override
    public void undo() throws CannotUndoException {
        RemoveEntityListenerAction action = this.actionManager.getAction(RemoveEntityListenerAction.class);
        action.removeEntityListener(this.objEntity, this.listener.getClassName());
    }
}

