/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.action.RemoveRelationshipAction;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class CreateRelationshipUndoableEdit
extends CayenneUndoableEdit {
    private ObjEntity objEnt;
    private ObjRelationship[] objectRel;
    private DbEntity dbEnt;
    private DbRelationship[] dbRel;

    public CreateRelationshipUndoableEdit(ObjEntity objEnt, ObjRelationship[] objectRel) {
        this.objEnt = objEnt;
        this.objectRel = objectRel;
    }

    public CreateRelationshipUndoableEdit(DbEntity dbEnt, DbRelationship[] dbRel) {
        this.dbEnt = dbEnt;
        this.dbRel = dbRel;
    }

    @Override
    public String getPresentationName() {
        return "Create Relationship";
    }

    @Override
    public void redo() throws CannotRedoException {
        CreateRelationshipAction action = this.actionManager.getAction(CreateRelationshipAction.class);
        if (this.objEnt != null) {
            for (ObjRelationship objRelationship : this.objectRel) {
                action.createObjRelationship(this.objEnt, objRelationship);
            }
        }
        if (this.dbEnt != null) {
            for (ObjRelationship objRelationship : this.dbRel) {
                action.createDbRelationship(this.dbEnt, (DbRelationship)objRelationship);
            }
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        RemoveRelationshipAction action = this.actionManager.getAction(RemoveRelationshipAction.class);
        if (this.objEnt != null) {
            action.removeObjRelationships(this.objEnt, this.objectRel);
            this.controller.fireObjEntityDisplayEvent(new EntityDisplayEvent((Object)this, (Entity)this.objEnt, this.objEnt.getDataMap(), (DataChannelDescriptor)this.controller.getProject().getRootNode()));
        }
        if (this.dbEnt != null) {
            action.removeDbRelationships(this.dbEnt, this.dbRel);
            this.controller.fireDbEntityDisplayEvent(new EntityDisplayEvent((Object)this, (Entity)this.dbEnt, this.dbEnt.getDataMap(), (DataChannelDescriptor)this.controller.getProject().getRootNode()));
        }
    }
}

