/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import java.util.Collection;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.event.DataNodeEvent;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.LinkDataMapAction;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class LinkDataMapUndoableEdit
extends CayenneUndoableEdit {
    DataMap map;
    DataNodeDescriptor node;
    Collection<DataNodeDescriptor> unlinkedNodes;
    ProjectController mediator;

    @Override
    public String getPresentationName() {
        return "Link unlinked DataMaps";
    }

    public LinkDataMapUndoableEdit(DataMap map, DataNodeDescriptor node, Collection<DataNodeDescriptor> unlinkedNodes, ProjectController mediator) {
        this.map = map;
        this.node = node;
        this.unlinkedNodes = unlinkedNodes;
        this.mediator = mediator;
    }

    @Override
    public void redo() throws CannotRedoException {
        LinkDataMapAction action = this.actionManager.getAction(LinkDataMapAction.class);
        action.linkDataMap(this.map, this.node);
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.node != null) {
            this.node.getDataMapNames().remove(this.map.getName());
            this.mediator.fireDataNodeEvent(new DataNodeEvent(this, this.node));
        }
        if (!this.unlinkedNodes.isEmpty()) {
            for (DataNodeDescriptor unlinkedNode : this.unlinkedNodes) {
                unlinkedNode.getDataMapNames().add(this.map.getName());
                this.mediator.fireDataNodeEvent(new DataNodeEvent(this, unlinkedNode));
            }
        }
    }
}

