/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.action.RemoveAttributeAction;
import org.apache.cayenne.modeler.action.RemoveCallbackMethodAction;
import org.apache.cayenne.modeler.action.RemoveProcedureParameterAction;
import org.apache.cayenne.modeler.action.RemoveRelationshipAction;
import org.apache.cayenne.modeler.editor.ObjCallbackMethod;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;
import org.apache.cayenne.query.Query;

public class PasteUndoableEdit
extends CayenneUndoableEdit {
    private DataChannelDescriptor domain;
    private DataMap map;
    private Object where;
    private Object content;

    public PasteUndoableEdit(DataChannelDescriptor domain, DataMap map, Object where, Object content) {
        this.domain = domain;
        this.map = map;
        this.where = where;
        this.content = content;
    }

    @Override
    public String getPresentationName() {
        String className = this.content.getClass().getName();
        int pos = className.lastIndexOf(".");
        String contentName = className.substring(pos + 1);
        return "Paste " + contentName;
    }

    @Override
    public void redo() throws CannotRedoException {
        PasteAction action = this.actionManager.getAction(PasteAction.class);
        action.paste(this.where, this.content, this.domain, this.map);
    }

    @Override
    public void undo() throws CannotUndoException {
        RemoveAttributeAction rAttributeAction = this.actionManager.getAction(RemoveAttributeAction.class);
        RemoveAction rAction = this.actionManager.getAction(RemoveAction.class);
        RemoveRelationshipAction rRelationShipAction = this.actionManager.getAction(RemoveRelationshipAction.class);
        RemoveCallbackMethodAction rCallbackMethodAction = this.actionManager.getAction(RemoveCallbackMethodAction.class);
        RemoveProcedureParameterAction rProcedureParamAction = this.actionManager.getAction(RemoveProcedureParameterAction.class);
        if (this.content instanceof DataMap) {
            if (this.where instanceof DataChannelDescriptor) {
                rAction.removeDataMap((DataMap)this.content);
            } else if (this.where instanceof DataNodeDescriptor) {
                rAction.removeDataMapFromDataNode((DataNodeDescriptor)this.where, (DataMap)this.content);
            }
        } else if (this.where instanceof DataMap) {
            if (this.content instanceof DbEntity) {
                rAction.removeDbEntity(this.map, (DbEntity)this.content);
            } else if (this.content instanceof ObjEntity) {
                rAction.removeObjEntity(this.map, (ObjEntity)this.content);
            } else if (this.content instanceof Embeddable) {
                rAction.removeEmbeddable(this.map, (Embeddable)this.content);
            } else if (this.content instanceof Query) {
                rAction.removeQuery(this.map, (Query)this.content);
            } else if (this.content instanceof Procedure) {
                rAction.removeProcedure(this.map, (Procedure)this.content);
            }
        } else if (this.where instanceof DbEntity) {
            if (this.content instanceof DbEntity) {
                rAction.removeDbEntity(this.map, (DbEntity)this.content);
            } else if (this.content instanceof DbAttribute) {
                rAttributeAction.removeDbAttributes(this.map, (DbEntity)this.where, new DbAttribute[]{(DbAttribute)this.content});
            } else if (this.content instanceof DbRelationship) {
                rRelationShipAction.removeDbRelationships((DbEntity)this.where, new DbRelationship[]{(DbRelationship)this.content});
            }
        } else if (this.where instanceof ObjEntity) {
            if (this.content instanceof ObjEntity) {
                rAction.removeObjEntity(this.map, (ObjEntity)this.content);
            } else if (this.content instanceof ObjAttribute) {
                rAttributeAction.removeObjAttributes((ObjEntity)this.where, new ObjAttribute[]{(ObjAttribute)this.content});
            } else if (this.content instanceof ObjRelationship) {
                rRelationShipAction.removeObjRelationships((ObjEntity)this.where, new ObjRelationship[]{(ObjRelationship)this.content});
            } else if (this.content instanceof ObjCallbackMethod) {
                ObjCallbackMethod[] methods;
                for (ObjCallbackMethod callbackMethod : methods = new ObjCallbackMethod[]{(ObjCallbackMethod)this.content}) {
                    rCallbackMethodAction.removeCallbackMethod(methods[0].getCallbackType(), callbackMethod.getName());
                }
            }
        } else if (this.where instanceof Procedure) {
            Procedure procedure = (Procedure)this.where;
            if (this.content instanceof ProcedureParameter) {
                rProcedureParamAction.removeProcedureParameters(procedure, new ProcedureParameter[]{(ProcedureParameter)this.content});
            }
        } else if (this.content instanceof Embeddable) {
            rAction.removeEmbeddable(this.map, (Embeddable)this.content);
        }
    }
}

