/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.dialog.ResolveDbRelationshipDialog;
import org.apache.cayenne.modeler.util.ProjectUtil;

public class RelationshipUndoableEdit
extends CompoundEdit {
    private DbRelationship relationship;

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        ResolveDbRelationshipDialog dialog = new ResolveDbRelationshipDialog(this.relationship, false);
        dialog.setVisible(true);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        ResolveDbRelationshipDialog dialog = new ResolveDbRelationshipDialog(this.relationship, false);
        dialog.setVisible(true);
    }

    @Override
    public String getRedoPresentationName() {
        return "Redo Edit relationship";
    }

    @Override
    public String getUndoPresentationName() {
        return "Undo Edit relationship";
    }

    public RelationshipUndoableEdit(DbRelationship relationship) {
        this.relationship = relationship;
    }

    public void addDbJoinAddUndo(final DbJoin join) {
        this.addEdit(new AbstractUndoableEdit(){

            @Override
            public void redo() throws CannotRedoException {
                RelationshipUndoableEdit.this.relationship.addJoin(join);
            }

            @Override
            public void undo() throws CannotUndoException {
                RelationshipUndoableEdit.this.relationship.removeJoin(join);
            }
        });
    }

    public void addDbJoinRemoveUndo(final DbJoin join) {
        this.addEdit(new AbstractUndoableEdit(){

            @Override
            public void redo() throws CannotRedoException {
                RelationshipUndoableEdit.this.relationship.removeJoin(join);
            }

            @Override
            public void undo() throws CannotUndoException {
                RelationshipUndoableEdit.this.relationship.addJoin(join);
            }
        });
    }

    public void addNameUndo(final DbRelationship relationship, final String oldName, final String newName) {
        this.addEdit(new AbstractUndoableEdit(){

            @Override
            public void redo() throws CannotRedoException {
                ProjectUtil.setRelationshipName((Entity)relationship.getSourceEntity(), (Relationship)relationship, newName);
            }

            @Override
            public void undo() throws CannotUndoException {
                ProjectUtil.setRelationshipName((Entity)relationship.getSourceEntity(), (Relationship)relationship, oldName);
            }
        });
    }
}

