/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.event.DataNodeEvent;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.CreateDataMapAction;
import org.apache.cayenne.modeler.action.CreateDbEntityAction;
import org.apache.cayenne.modeler.action.CreateEmbeddableAction;
import org.apache.cayenne.modeler.action.CreateNodeAction;
import org.apache.cayenne.modeler.action.CreateObjEntityAction;
import org.apache.cayenne.modeler.action.CreateProcedureAction;
import org.apache.cayenne.modeler.action.CreateQueryAction;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;
import org.apache.cayenne.query.Query;

public class RemoveUndoableEdit
extends CayenneUndoableEdit {
    private DataMap map;
    private DbEntity dbEntity;
    private ObjEntity objEntity;
    private Query query;
    private Procedure procedure;
    private DataNodeDescriptor dataNode;
    private DataChannelDescriptor domain;
    private Embeddable embeddable;
    private Map<DbEntity, List<DbRelationship>> dbRelationshipMap = new HashMap<DbEntity, List<DbRelationship>>();
    private Map<ObjEntity, List<ObjRelationship>> objRelationshipMap = new HashMap<ObjEntity, List<ObjRelationship>>();
    private REMOVE_MODE mode;

    public RemoveUndoableEdit(Application application) {
        this.domain = (DataChannelDescriptor)application.getProject().getRootNode();
        this.mode = REMOVE_MODE.DOMAIN;
    }

    public RemoveUndoableEdit(Application application, DataNodeDescriptor node, DataMap map) {
        this.map = map;
        this.dataNode = node;
        this.mode = REMOVE_MODE.MAP_FROM_NODE;
    }

    public RemoveUndoableEdit(Application application, DataMap map) {
        this.domain = (DataChannelDescriptor)application.getProject().getRootNode();
        this.map = map;
        this.mode = REMOVE_MODE.MAP_FROM_DOMAIN;
    }

    public RemoveUndoableEdit(Application application, DataNodeDescriptor node) {
        this.domain = (DataChannelDescriptor)application.getProject().getRootNode();
        this.dataNode = node;
        this.mode = REMOVE_MODE.NODE;
    }

    public RemoveUndoableEdit(DataMap map, ObjEntity objEntity) {
        this.map = map;
        this.objEntity = objEntity;
        this.mode = REMOVE_MODE.OBJECT_ENTITY;
        for (ObjEntity ent : map.getObjEntities()) {
            for (Relationship relationship : new ArrayList(ent.getRelationships())) {
                if (!this.objEntity.getName().equals(relationship.getTargetEntityName())) continue;
                ObjRelationship rel = (ObjRelationship)relationship;
                if (this.objRelationshipMap.get(rel.getSourceEntity()) == null) {
                    this.objRelationshipMap.put(rel.getSourceEntity(), new LinkedList());
                }
                this.objRelationshipMap.get(rel.getSourceEntity()).add(rel);
            }
        }
    }

    public RemoveUndoableEdit(DataMap map, DbEntity dbEntity) {
        this.map = map;
        this.dbEntity = dbEntity;
        this.mode = REMOVE_MODE.DB_ENTITY;
        for (ObjEntity objEnt : map.getObjEntities()) {
            block1: for (Relationship rel : objEnt.getRelationships()) {
                for (DbRelationship dbRel : ((ObjRelationship)rel).getDbRelationships()) {
                    if (dbRel.getTargetEntity() != dbEntity) continue;
                    if (this.dbRelationshipMap.get(dbRel.getSourceEntity()) == null) {
                        this.dbRelationshipMap.put(dbRel.getSourceEntity(), new LinkedList());
                    }
                    this.dbRelationshipMap.get(dbRel.getSourceEntity()).add(dbRel);
                    continue block1;
                }
            }
        }
    }

    public RemoveUndoableEdit(DataMap map, Query query) {
        this.map = map;
        this.query = query;
        this.mode = REMOVE_MODE.QUERY;
    }

    public RemoveUndoableEdit(DataMap map, Procedure procedure) {
        this.map = map;
        this.procedure = procedure;
        this.mode = REMOVE_MODE.PROCEDURE;
    }

    public RemoveUndoableEdit(DataMap map, Embeddable embeddable) {
        this.map = map;
        this.embeddable = embeddable;
        this.mode = REMOVE_MODE.EMBEDDABLE;
    }

    @Override
    public String getPresentationName() {
        switch (this.mode) {
            case OBJECT_ENTITY: {
                return "Remove Object Entity";
            }
            case DB_ENTITY: {
                return "Remove Db Entity";
            }
            case QUERY: {
                return "Remove Query";
            }
            case PROCEDURE: {
                return "Remove Procedure";
            }
            case MAP_FROM_NODE: {
                return "Remove DataMap";
            }
            case MAP_FROM_DOMAIN: {
                return "Remove DataMap";
            }
            case NODE: {
                return "Remove DataNode";
            }
            case DOMAIN: {
                return "Remove DataDomain";
            }
            case EMBEDDABLE: {
                return "Remove Embeddable";
            }
        }
        return "Remove";
    }

    @Override
    public void redo() throws CannotRedoException {
        RemoveAction action = this.actionManager.getAction(RemoveAction.class);
        switch (this.mode) {
            case OBJECT_ENTITY: {
                action.removeObjEntity(this.map, this.objEntity);
                break;
            }
            case DB_ENTITY: {
                action.removeDbEntity(this.map, this.dbEntity);
                break;
            }
            case QUERY: {
                action.removeQuery(this.map, this.query);
                break;
            }
            case PROCEDURE: {
                action.removeProcedure(this.map, this.procedure);
            }
            case MAP_FROM_NODE: {
                action.removeDataMapFromDataNode(this.dataNode, this.map);
                break;
            }
            case MAP_FROM_DOMAIN: {
                action.removeDataMap(this.map);
                break;
            }
            case NODE: {
                action.removeDataNode(this.dataNode);
                break;
            }
            case EMBEDDABLE: {
                action.removeEmbeddable(this.map, this.embeddable);
            }
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        CreateRelationshipAction relationshipAction = this.actionManager.getAction(CreateRelationshipAction.class);
        switch (this.mode) {
            case OBJECT_ENTITY: {
                for (Map.Entry<ObjEntity, List<ObjRelationship>> entry : this.objRelationshipMap.entrySet()) {
                    ObjEntity objEntity = entry.getKey();
                    for (ObjRelationship rel : entry.getValue()) {
                        relationshipAction.createObjRelationship(objEntity, rel);
                    }
                }
                CreateObjEntityAction action = this.actionManager.getAction(CreateObjEntityAction.class);
                action.createObjEntity(this.map, this.objEntity);
                break;
            }
            case DB_ENTITY: {
                for (Map.Entry<DbEntity, List<DbRelationship>> entry : this.dbRelationshipMap.entrySet()) {
                    DbEntity dbEntity = entry.getKey();
                    for (DbRelationship rel : entry.getValue()) {
                        relationshipAction.createDbRelationship(dbEntity, rel);
                    }
                }
                CreateDbEntityAction action = this.actionManager.getAction(CreateDbEntityAction.class);
                action.createEntity(this.map, this.dbEntity);
                break;
            }
            case QUERY: {
                this.domain = (DataChannelDescriptor)Application.getInstance().getFrameController().getProjectController().getProject().getRootNode();
                CreateQueryAction action = this.actionManager.getAction(CreateQueryAction.class);
                action.createQuery(this.domain, this.map, this.query);
                break;
            }
            case PROCEDURE: {
                CreateProcedureAction action = this.actionManager.getAction(CreateProcedureAction.class);
                action.createProcedure(this.map, this.procedure);
                break;
            }
            case MAP_FROM_NODE: {
                this.dataNode.getDataMapNames().add(this.map.getName());
                DataNodeEvent e = new DataNodeEvent(Application.getFrame(), this.dataNode);
                ProjectController controller = Application.getInstance().getFrameController().getProjectController();
                e.setDomain((DataChannelDescriptor)controller.getProject().getRootNode());
                controller.fireDataNodeEvent(e);
                break;
            }
            case MAP_FROM_DOMAIN: {
                CreateDataMapAction action = this.actionManager.getAction(CreateDataMapAction.class);
                action.createDataMap(this.map);
                break;
            }
            case NODE: {
                CreateNodeAction action = this.actionManager.getAction(CreateNodeAction.class);
                action.createDataNode(this.dataNode);
                break;
            }
            case EMBEDDABLE: {
                CreateEmbeddableAction action = this.actionManager.getAction(CreateEmbeddableAction.class);
                action.createEmbeddable(this.map, this.embeddable);
                break;
            }
        }
    }

    private static enum REMOVE_MODE {
        OBJECT_ENTITY,
        DB_ENTITY,
        QUERY,
        PROCEDURE,
        MAP_FROM_NODE,
        MAP_FROM_DOMAIN,
        NODE,
        DOMAIN,
        EMBEDDABLE;

    }
}

