/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.Util;

public class ProjectUtil {
    public static void setProcedureParameterName(ProcedureParameter parameter, String newName) {
        String oldName = parameter.getName();
        if (Util.nullSafeEquals((Object)oldName, (Object)newName)) {
            return;
        }
        Procedure procedure = parameter.getProcedure();
        procedure.removeCallParameter(parameter.getName());
        parameter.setName(newName);
        procedure.addCallParameter(parameter);
    }

    public static void setDataMapName(DataChannelDescriptor domain, DataMap map, String newName) {
        String oldName = map.getName();
        ArrayList<DataNodeDescriptor> nodes = new ArrayList<DataNodeDescriptor>();
        for (DataNodeDescriptor node : domain.getNodeDescriptors()) {
            if (!node.getDataMapNames().contains(map.getName())) continue;
            nodes.add(node);
        }
        map.setName(newName);
        for (DataNodeDescriptor node : nodes) {
            node.getDataMapNames().remove(oldName);
            node.getDataMapNames().add(map.getName());
        }
    }

    public static void setDataNodeName(DataChannelDescriptor domain, DataNodeDescriptor node, String newName) {
        node.setName(newName);
    }

    public static void setProcedureName(DataMap map, Procedure procedure, String newName) {
        String oldName = procedure.getName();
        if (Util.nullSafeEquals((Object)oldName, (Object)newName)) {
            return;
        }
        procedure.setName(newName);
        map.removeProcedure(oldName);
        map.addProcedure(procedure);
        MappingNamespace ns = map.getNamespace();
        if (ns instanceof EntityResolver) {
            ((EntityResolver)ns).refreshMappingCache();
        }
    }

    public static void setQueryName(DataMap map, Query query, String newName) {
        String oldName = query.getName();
        if (Util.nullSafeEquals((Object)oldName, (Object)newName)) {
            return;
        }
        if (query instanceof AbstractQuery) {
            ((AbstractQuery)query).setName(newName);
            ((AbstractQuery)query).setDataMap(map);
        }
        if (query instanceof EJBQLQuery) {
            ((EJBQLQuery)query).setName(newName);
            ((EJBQLQuery)query).setDataMap(map);
        }
        map.removeQuery(oldName);
        map.addQuery(query);
        MappingNamespace ns = map.getNamespace();
        if (ns instanceof EntityResolver) {
            ((EntityResolver)ns).refreshMappingCache();
        }
    }

    public static void setObjEntityName(DataMap map, ObjEntity entity, String newName) {
        String oldName = entity.getName();
        if (Util.nullSafeEquals((Object)oldName, (Object)newName)) {
            return;
        }
        entity.setName(newName);
        map.removeObjEntity(oldName, false);
        map.addObjEntity(entity);
        MappingNamespace ns = map.getNamespace();
        if (ns instanceof EntityResolver) {
            ((EntityResolver)ns).refreshMappingCache();
        }
    }

    public static void setDbEntityName(DbEntity entity, String newName) {
        String oldName = entity.getName();
        if (Util.nullSafeEquals((Object)oldName, (Object)newName)) {
            return;
        }
        entity.setName(newName);
        DataMap map = entity.getDataMap();
        if (map != null) {
            map.removeDbEntity(oldName, false);
            map.addDbEntity(entity);
            MappingNamespace ns = map.getNamespace();
            if (ns instanceof EntityResolver) {
                ((EntityResolver)ns).refreshMappingCache();
            }
        }
    }

    public static void setAttributeName(Attribute attribute, String newName) {
        String oldName = attribute.getName();
        attribute.setName(newName);
        Entity entity = attribute.getEntity();
        if (entity != null) {
            entity.removeAttribute(oldName);
            entity.addAttribute(attribute);
        }
    }

    public static void setEmbeddableAttributeName(EmbeddableAttribute attribute, String newName) {
        String oldName = attribute.getName();
        attribute.setName(newName);
        Embeddable embeddable = attribute.getEmbeddable();
        if (embeddable != null) {
            embeddable.removeAttribute(oldName);
            embeddable.addAttribute(attribute);
        }
    }

    public static void setRelationshipName(Entity entity, Relationship rel, String newName) {
        if (rel == null || rel != entity.getRelationship(rel.getName())) {
            return;
        }
        entity.removeRelationship(rel.getName());
        rel.setName(newName);
        entity.addRelationship(rel);
    }

    public static void cleanObjMappings(DataMap map) {
        for (ObjEntity entity : map.getObjEntities()) {
            DbEntity dbEnt = entity.getDbEntity();
            if (dbEnt != null && map.getDbEntity(dbEnt.getName()) != dbEnt) {
                ProjectUtil.clearDbMapping(entity);
                continue;
            }
            for (ObjAttribute att : entity.getAttributes()) {
                if (att.getDbAttributePath() != null && att.getDbAttributePath().contains(".")) {
                    String[] pathSplit = att.getDbAttributePath().split("\\.");
                    if (pathSplit.length <= 1) continue;
                    DbEntity currentEnt = dbEnt;
                    StringBuilder pathBuf = new StringBuilder();
                    boolean isTruePath = true;
                    if (currentEnt != null) {
                        for (int j = 0; j < pathSplit.length; ++j) {
                            if (j == pathSplit.length - 1 && isTruePath) {
                                DbAttribute dbAttribute = currentEnt.getAttribute(pathSplit[j]);
                                if (dbAttribute != null) {
                                    pathBuf.append(dbAttribute.getName());
                                    continue;
                                }
                                isTruePath = false;
                                continue;
                            }
                            if (!isTruePath) continue;
                            DbRelationship dbRelationship = currentEnt.getRelationship(pathSplit[j]);
                            if (dbRelationship != null) {
                                currentEnt = dbRelationship.getTargetEntity();
                                pathBuf.append(dbRelationship.getName());
                                pathBuf.append(".");
                                continue;
                            }
                            isTruePath = false;
                        }
                    }
                    if (isTruePath) continue;
                    att.setDbAttributePath(null);
                    continue;
                }
                DbAttribute dbAtt = att.getDbAttribute();
                if (dbAtt == null || dbEnt.getAttribute(dbAtt.getName()) == dbAtt) continue;
                att.setDbAttributePath(null);
            }
            for (ObjRelationship rel : entity.getRelationships()) {
                ArrayList dbRelList = new ArrayList(rel.getDbRelationships());
                for (DbRelationship dbRel : dbRelList) {
                    DbEntity srcEnt = dbRel.getSourceEntity();
                    if (srcEnt != null && map.getDbEntity(srcEnt.getName()) == srcEnt && srcEnt.getRelationship(dbRel.getName()) == dbRel) continue;
                    rel.removeDbRelationship(dbRel);
                }
            }
        }
    }

    public static void clearDbMapping(ObjEntity entity) {
        DbEntity db_entity = entity.getDbEntity();
        if (db_entity == null) {
            return;
        }
        for (ObjAttribute objAttr : entity.getAttributeMap().values()) {
            DbAttribute dbAttr = objAttr.getDbAttribute();
            if (null == dbAttr) continue;
            objAttr.setDbAttributePath(null);
        }
        for (ObjRelationship obj_rel : entity.getRelationships()) {
            obj_rel.clearDbRelationships();
        }
        entity.setDbEntity(null);
    }

    public static boolean containsSourceAttribute(DbRelationship relationship, DbAttribute attribute) {
        if (attribute.getEntity() != relationship.getSourceEntity()) {
            return false;
        }
        for (DbJoin join : relationship.getJoins()) {
            if (join.getSource() != attribute) continue;
            return true;
        }
        return false;
    }

    public static boolean containsTargetAttribute(DbRelationship relationship, DbAttribute attribute) {
        if (attribute.getEntity() != relationship.getTargetEntity()) {
            return false;
        }
        for (DbJoin join : relationship.getJoins()) {
            if (join.getTarget() != attribute) continue;
            return true;
        }
        return false;
    }

    public static Collection<DbRelationship> getRelationshipsUsingAttributeAsSource(DbAttribute attribute) {
        DbEntity parent = attribute.getEntity();
        if (parent == null) {
            return Collections.EMPTY_LIST;
        }
        Collection parentRelationships = parent.getRelationships();
        ArrayList<DbRelationship> relationships = new ArrayList<DbRelationship>(parentRelationships.size());
        for (DbRelationship relationship : parentRelationships) {
            if (!ProjectUtil.containsSourceAttribute(relationship, attribute)) continue;
            relationships.add(relationship);
        }
        return relationships;
    }

    public static Collection<DbRelationship> getRelationshipsUsingAttributeAsTarget(DbAttribute attribute) {
        DbEntity parent = attribute.getEntity();
        if (parent == null) {
            return Collections.EMPTY_LIST;
        }
        DataMap map = parent.getDataMap();
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DbRelationship> relationships = new ArrayList<DbRelationship>();
        for (Entity entity : map.getDbEntities()) {
            if (entity == parent) continue;
            Collection entityRelationships = entity.getRelationships();
            for (DbRelationship relationship : entityRelationships) {
                if (!ProjectUtil.containsTargetAttribute(relationship, attribute)) continue;
                relationships.add(relationship);
            }
        }
        return relationships;
    }
}

