/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util.combo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.CellRendererPane;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class EditorTextField
extends JTextField
implements FocusListener {
    protected JComboBox combo;
    private final CellRendererPane rendererPane;
    private final JList list = new JList();
    private boolean hasFocus;

    public EditorTextField(JComboBox edited) {
        this.combo = edited;
        this.rendererPane = new CellRendererPane();
        this.addFocusListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.hasFocus) {
            super.paintComponent(g);
        } else {
            this.list.setEnabled(this.combo.isEnabled());
            ListCellRenderer<Object> renderer = this.combo.getRenderer();
            Component c = renderer.getListCellRendererComponent(this.list, this.combo.getSelectedItem(), -1, false, false);
            Color oldColor = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(oldColor);
            Insets insets = this.getInsets();
            this.rendererPane.paintComponent(g, c, this.combo, insets.left, insets.top, this.getWidth() - insets.right - insets.left, this.getHeight() - insets.bottom - insets.top);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.hasFocus = true;
        this.combo.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.hasFocus = false;
        this.combo.repaint();
    }
}

