/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.pref;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.pref.CayenneProjectPreferences;
import org.apache.cayenne.pref.PreferenceEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CayennePreferenceEditor
implements PreferenceEditor {
    protected boolean restartRequired;
    protected CayenneProjectPreferences cayenneProjectPreferences;
    private Map<Preferences, Map<String, String>> changedPreferences;
    private Map<Preferences, Map<String, String>> removedPreferences;
    private Map<Preferences, Map<String, Boolean>> changedBooleanPreferences;
    private List<Preferences> removedNode;
    private List<Preferences> addedNode;
    private static Log logger = LogFactory.getLog(CayennePreferenceEditor.class);

    public CayennePreferenceEditor(CayenneProjectPreferences cayenneProjectPreferences) {
        this.cayenneProjectPreferences = cayenneProjectPreferences;
        this.changedPreferences = new HashMap<Preferences, Map<String, String>>();
        this.removedPreferences = new HashMap<Preferences, Map<String, String>>();
        this.changedBooleanPreferences = new HashMap<Preferences, Map<String, Boolean>>();
        this.removedNode = new ArrayList<Preferences>();
        this.addedNode = new ArrayList<Preferences>();
    }

    public List<Preferences> getAddedNode() {
        return this.addedNode;
    }

    public List<Preferences> getRemovedNode() {
        return this.removedNode;
    }

    public Map<Preferences, Map<String, String>> getRemovedPreferences() {
        return this.removedPreferences;
    }

    public Map<Preferences, Map<String, String>> getChangedPreferences() {
        return this.changedPreferences;
    }

    public Map<Preferences, Map<String, Boolean>> getChangedBooleanPreferences() {
        return this.changedBooleanPreferences;
    }

    protected boolean isRestartRequired() {
        return this.restartRequired;
    }

    protected void setRestartRequired(boolean restartOnSave) {
        this.restartRequired = restartOnSave;
    }

    @Override
    public void save() {
        this.cayenneProjectPreferences.getDetailObject(DBConnectionInfo.class).save();
        if (this.restartRequired) {
            this.restart();
        }
        for (Map.Entry<Preferences, Map<String, Boolean>> entry : this.changedBooleanPreferences.entrySet()) {
            Preferences pref = entry.getKey();
            Map<String, Boolean> map = entry.getValue();
            for (Map.Entry<String, Boolean> en : map.entrySet()) {
                String key = en.getKey();
                Boolean value = en.getValue();
                pref.putBoolean(key, value);
            }
        }
        for (Map.Entry<Preferences, Map<String, String>> entry : this.changedPreferences.entrySet()) {
            Preferences pref = entry.getKey();
            Map<String, String> map = entry.getValue();
            for (Map.Entry<String, String> en : map.entrySet()) {
                String key = en.getKey();
                String value = en.getValue();
                pref.put(key, value);
            }
        }
        for (Map.Entry<Preferences, Map<String, String>> entry : this.removedPreferences.entrySet()) {
            Preferences pref = entry.getKey();
            Map<String, String> map = entry.getValue();
            for (Map.Entry<String, String> en : map.entrySet()) {
                String key = en.getKey();
                pref.remove(key);
            }
        }
        for (Preferences pref : this.removedNode) {
            try {
                pref.removeNode();
            }
            catch (BackingStoreException e) {
                logger.warn((Object)"Error removing preferences");
            }
        }
        Application.getInstance().initClassLoader();
    }

    @Override
    public void revert() {
        for (Preferences pref : this.addedNode) {
            try {
                pref.removeNode();
            }
            catch (BackingStoreException backingStoreException) {}
        }
        this.cayenneProjectPreferences.getDetailObject(DBConnectionInfo.class).cancel();
        this.restartRequired = false;
    }

    protected abstract void restart();
}

