/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing;

import ognl.Ognl;
import ognl.OgnlException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.swing.BindingDelegate;
import org.apache.cayenne.swing.BindingException;
import org.apache.cayenne.swing.ObjectBinding;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;

public abstract class BindingBase
implements ObjectBinding {
    private Object compiled;
    protected Object context;
    protected String expression;
    protected BindingDelegate delegate;
    protected boolean modelUpdateDisabled;
    protected boolean usingNullForEmptyStrings;
    protected boolean checkingForValueChange;

    static Throwable unwind(Throwable th) {
        if (th instanceof OgnlException) {
            Throwable reason = ((OgnlException)th).getReason();
            return reason != null ? BindingBase.unwind(reason) : th;
        }
        return Util.unwindException((Throwable)th);
    }

    public BindingBase(String propertyExpression) {
        try {
            this.compiled = Ognl.parseExpression((String)propertyExpression);
        }
        catch (OgnlException ex) {
            throw new CayenneRuntimeException("Invalid expression - " + propertyExpression, BindingBase.unwind(ex), new Object[0]);
        }
        this.expression = propertyExpression;
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    @Override
    public void setContext(Object object) {
        this.context = object;
    }

    public boolean isCheckingForValueChange() {
        return this.checkingForValueChange;
    }

    public void setCheckingForValueChange(boolean checkingForValueChange) {
        this.checkingForValueChange = checkingForValueChange;
    }

    public boolean isUsingNullForEmptyStrings() {
        return this.usingNullForEmptyStrings;
    }

    public void setUsingNullForEmptyStrings(boolean b) {
        this.usingNullForEmptyStrings = b;
    }

    public String getExpression() {
        return this.expression;
    }

    @Override
    public BindingDelegate getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(BindingDelegate delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object value) {
        if (this.context == null) {
            throw new BindingException("No context", new Object[0]);
        }
        try {
            if (this.modelUpdateDisabled) {
                return;
            }
            Object oldValue = null;
            this.modelUpdateDisabled = true;
            try {
                if (this.delegate != null) {
                    oldValue = this.getValue();
                }
                if (this.isUsingNullForEmptyStrings() && "".equals(value)) {
                    value = null;
                }
                if (this.isCheckingForValueChange()) {
                    Object existingValue;
                    Object object = existingValue = this.delegate != null ? oldValue : this.getValue();
                    if (Util.nullSafeEquals((Object)value, (Object)existingValue)) {
                        return;
                    }
                }
                Ognl.setValue((Object)this.compiled, (Object)this.context, (Object)value);
            }
            finally {
                this.modelUpdateDisabled = false;
            }
            if (this.delegate != null) {
                this.delegate.modelUpdated(this, oldValue, value);
            }
        }
        catch (OgnlException ex) {
            this.processException(ex);
        }
    }

    public Object getValue() {
        if (this.context == null) {
            throw new BindingException("No context", new Object[0]);
        }
        try {
            return Ognl.getValue((Object)this.compiled, (Object)this.context);
        }
        catch (OgnlException ex) {
            this.processException(ex);
            return null;
        }
    }

    protected void processException(Throwable th) throws ValidationException, BindingException {
        Throwable root = BindingBase.unwind(th);
        if (root instanceof ValidationException) {
            throw (ValidationException)root;
        }
        if (root instanceof NumberFormatException) {
            throw new ValidationException("Invalid numeric string", new Object[0]);
        }
        throw new BindingException("Evaluation failed in context: " + this.context, root, new Object[0]);
    }
}

