/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing.components.textpane;

import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.apache.cayenne.swing.components.textpane.style.SyntaxStyle;
import org.apache.cayenne.swing.components.textpane.style.TextPaneStyleMap;
import org.apache.cayenne.swing.components.textpane.style.TextPaneStyleTypes;
import org.apache.cayenne.swing.components.textpane.syntax.SQLSyntaxConstants;
import org.apache.cayenne.swing.components.textpane.syntax.SyntaxConstant;

public class TextPaneView
extends PlainView {
    private static HashMap<Pattern, SyntaxStyle> patternSyntaxStyle = new HashMap();
    private static Pattern patternComment;
    private static Pattern patternCommentStart;
    private static SyntaxStyle syntaxStyleComment;
    private static HashMap<Pattern, SyntaxStyle> patternValue;

    public TextPaneView(Element elem, SyntaxConstant syntaxConstants) {
        super(elem);
        this.getDocument().putProperty("tabSize", 4);
        TextPaneStyleMap style = new TextPaneStyleMap();
        if (patternSyntaxStyle.size() == 0) {
            String patern;
            int i;
            String[] keywords = syntaxConstants.getKEYWORDS();
            String[] keywords2 = syntaxConstants.getKEYWORDS2();
            String[] operators = syntaxConstants.getOPERATORS();
            String[] types = syntaxConstants.getTYPES();
            for (i = 0; i < keywords.length; ++i) {
                patern = "(" + keywords[i] + ")";
                patternSyntaxStyle.put(Pattern.compile(patern, 66), style.syntaxStyleMap.get((Object)TextPaneStyleTypes.KEYWORDS));
            }
            for (i = 0; i < keywords2.length; ++i) {
                patern = "(" + keywords2[i] + ")";
                patternSyntaxStyle.put(Pattern.compile(patern, 66), style.syntaxStyleMap.get((Object)TextPaneStyleTypes.KEYWORDS2));
            }
            for (i = 0; i < operators.length; ++i) {
                patern = "(" + operators[i] + ")";
                patternSyntaxStyle.put(Pattern.compile(patern, 66), style.syntaxStyleMap.get((Object)TextPaneStyleTypes.KEYWORDS));
            }
            for (i = 0; i < types.length; ++i) {
                patern = "(" + types[i] + ")";
                patternSyntaxStyle.put(Pattern.compile(patern, 66), style.syntaxStyleMap.get((Object)TextPaneStyleTypes.TYPE));
            }
        }
        if (patternValue.size() == 0) {
            patternValue.put(Pattern.compile("\\d+"), style.syntaxStyleMap.get((Object)TextPaneStyleTypes.NUMBER));
        }
        patternComment = Pattern.compile("(?:/\\*(?:[^*]|(?:\\*+[^*/]))*\\*+/)|(?://.*)", 66);
        patternCommentStart = Pattern.compile("/\\*.?", 66);
        syntaxStyleComment = style.syntaxStyleMap.get((Object)TextPaneStyleTypes.COMMENT);
    }

    @Override
    protected int drawUnselectedText(Graphics graphics, int x, int y, int p0, int p1) throws BadLocationException {
        boolean lineComment = false;
        HashMap<Integer, Integer> comment = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> commentInLine = new HashMap<Integer, Integer>();
        StyledDocument doc = (StyledDocument)this.getDocument();
        String text = doc.getText(p0, p1 - p0);
        Segment segment = this.getLineBuffer();
        Matcher m = patternComment.matcher(doc.getText(0, doc.getLength()));
        int maxEnd = 0;
        while (m.find()) {
            comment.put(m.start(), m.end());
            if (maxEnd >= m.end()) continue;
            maxEnd = m.end();
        }
        Matcher m3 = patternCommentStart.matcher(doc.getText(0, doc.getLength()));
        while (m3.find()) {
            if (maxEnd >= m3.start()) continue;
            comment.put(m3.start(), doc.getLength());
            break;
        }
        int j = 0;
        for (Map.Entry entry : comment.entrySet()) {
            if (p0 >= (Integer)entry.getKey() && p1 <= (Integer)entry.getValue()) {
                lineComment = true;
                break;
            }
            if (p0 <= (Integer)entry.getKey() && p1 >= (Integer)entry.getValue()) {
                commentInLine.put((Integer)entry.getKey() - p0, (Integer)entry.getValue() - p0);
            } else if (p0 <= (Integer)entry.getKey() && p1 >= (Integer)entry.getKey() && p1 < (Integer)entry.getValue()) {
                commentInLine.put((Integer)entry.getKey() - p0, p1 - p0);
            } else if (p0 <= (Integer)entry.getValue() && p1 >= (Integer)entry.getValue() && p0 > (Integer)entry.getKey()) {
                commentInLine.put(0, (Integer)entry.getValue() - p0);
            }
            ++j;
        }
        TreeMap<Integer, Integer> startMap = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Object> syntaxStyleMap = new TreeMap<Integer, Object>();
        if (lineComment) {
            startMap.put(0, text.length());
            syntaxStyleMap.put(0, syntaxStyleComment);
        } else {
            boolean inComment;
            Matcher matcher;
            for (Map.Entry entry : commentInLine.entrySet()) {
                startMap.put((Integer)entry.getKey(), (Integer)entry.getValue());
                syntaxStyleMap.put((Integer)entry.getKey(), syntaxStyleComment);
            }
            for (Map.Entry<Object, Object> entry : patternSyntaxStyle.entrySet()) {
                matcher = ((Pattern)entry.getKey()).matcher(text);
                while (matcher.find()) {
                    if (text.length() != matcher.end() && text.charAt(matcher.end()) != '\t' && text.charAt(matcher.end()) != ' ' && text.charAt(matcher.end()) != '\n' || matcher.start() != 0 && text.charAt(matcher.start() - 1) != '\t' && text.charAt(matcher.start() - 1) != '\n' && text.charAt(matcher.start() - 1) != ' ') continue;
                    inComment = false;
                    for (Map.Entry entryCommentInLine : commentInLine.entrySet()) {
                        if (matcher.start(1) < (Integer)entryCommentInLine.getKey() || matcher.end() > (Integer)entryCommentInLine.getValue()) continue;
                        inComment = true;
                    }
                    if (inComment) continue;
                    startMap.put(matcher.start(1), matcher.end());
                    syntaxStyleMap.put(matcher.start(1), entry.getValue());
                }
            }
            for (Map.Entry<Object, Object> entry : patternValue.entrySet()) {
                matcher = ((Pattern)entry.getKey()).matcher(text);
                while (matcher.find()) {
                    if (text.length() != matcher.end() && text.charAt(matcher.end()) != ' ' && text.charAt(matcher.end()) != ')' && text.charAt(matcher.end()) != '\t' && text.charAt(matcher.end()) != '\n' || matcher.start() != 0 && text.charAt(matcher.start() - 1) != '\t' && text.charAt(matcher.start() - 1) != ' ' && text.charAt(matcher.start() - 1) != '=' && text.charAt(matcher.start() - 1) != '(') continue;
                    inComment = false;
                    for (Map.Entry entryCommentInLine : commentInLine.entrySet()) {
                        if (matcher.start() < (Integer)entryCommentInLine.getKey() || matcher.end() > (Integer)entryCommentInLine.getValue()) continue;
                        inComment = true;
                    }
                    if (inComment) continue;
                    startMap.put(matcher.start(), matcher.end());
                    syntaxStyleMap.put(matcher.start(), entry.getValue());
                }
            }
        }
        int i = 0;
        for (Map.Entry entry : startMap.entrySet()) {
            int start = (Integer)entry.getKey();
            int end = (Integer)entry.getValue();
            if (i < start) {
                graphics.setColor(SQLSyntaxConstants.DEFAULT_COLOR);
                graphics.setFont(SQLSyntaxConstants.DEFAULT_FONT);
                doc.getText(p0 + i, start - i, segment);
                x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, i);
            }
            graphics.setFont(((SyntaxStyle)syntaxStyleMap.get(start)).getFont());
            graphics.setColor(((SyntaxStyle)syntaxStyleMap.get(start)).getColor());
            i = end;
            doc.getText(p0 + start, i - start, segment);
            x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, start);
        }
        if (i < text.length()) {
            graphics.setColor(SQLSyntaxConstants.DEFAULT_COLOR);
            graphics.setFont(SQLSyntaxConstants.DEFAULT_FONT);
            doc.getText(p0 + i, text.length() - i, segment);
            x = Utilities.drawTabbedText(segment, x, y, graphics, (TabExpander)this, i);
        }
        return x;
    }

    static {
        patternValue = new HashMap();
    }
}

