/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.xml.bind.JAXBElement;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AbstractAtomPubService;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomElement;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomEntry;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomFeed;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomLink;
import org.apache.chemistry.opencmis.client.bindings.spi.http.HttpUtils;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.JaxBHelper;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectListImpl;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisQueryType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumIncludeRelationships;
import org.apache.chemistry.opencmis.commons.spi.DiscoveryService;
import org.apache.chemistry.opencmis.commons.spi.Holder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryServiceImpl
extends AbstractAtomPubService
implements DiscoveryService {
    public DiscoveryServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    public ObjectList getContentChanges(String repositoryId, Holder<String> changeLogToken, Boolean includeProperties, String filter, Boolean includePolicyIds, Boolean includeACL, BigInteger maxItems, ExtensionsData extension) {
        ObjectListImpl result = new ObjectListImpl();
        String link = this.loadRepositoryLink(repositoryId, "http://docs.oasis-open.org/ns/cmis/link/200908/changes");
        if (link == null) {
            throw new CmisObjectNotFoundException("Unknown repository or content changes not supported!");
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("changeLogToken", changeLogToken == null ? null : (String)changeLogToken.getValue());
        url.addParameter("includeProperties", (Object)includeProperties);
        url.addParameter("filter", (Object)filter);
        url.addParameter("includePolicyIds", (Object)includePolicyIds);
        url.addParameter("includeACL", (Object)includeACL);
        url.addParameter("maxItems", (Object)maxItems);
        HttpUtils.Response resp = this.read(url);
        AtomFeed feed = this.parse(resp.getStream(), AtomFeed.class);
        for (AtomElement element : feed.getElements()) {
            if (element.getObject() instanceof AtomLink) {
                if (!this.isNextLink(element)) continue;
                result.setHasMoreItems(Boolean.TRUE);
                continue;
            }
            if (!this.isInt("numItems", element)) continue;
            result.setNumItems((BigInteger)element.getObject());
        }
        if (!feed.getEntries().isEmpty()) {
            result.setObjects(new ArrayList(feed.getEntries().size()));
            for (AtomEntry entry : feed.getEntries()) {
                ObjectData hit = null;
                for (AtomElement element : entry.getElements()) {
                    if (!(element.getObject() instanceof CmisObjectType)) continue;
                    hit = Converter.convert((CmisObjectType)((CmisObjectType)element.getObject()));
                }
                if (hit == null) continue;
                result.getObjects().add(hit);
            }
        }
        return result;
    }

    public ObjectList query(String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        ObjectListImpl result = new ObjectListImpl();
        String link = this.loadCollection(repositoryId, "query");
        if (link == null) {
            throw new CmisObjectNotFoundException("Unknown repository or query not supported!");
        }
        UrlBuilder url = new UrlBuilder(link);
        final CmisQueryType query = new CmisQueryType();
        query.setStatement(statement);
        query.setSearchAllVersions(searchAllVersions);
        query.setIncludeAllowableActions(includeAllowableActions);
        query.setIncludeRelationships((EnumIncludeRelationships)Converter.convert(EnumIncludeRelationships.class, (Enum)includeRelationships));
        query.setRenditionFilter(renditionFilter);
        query.setMaxItems(maxItems);
        query.setSkipCount(skipCount);
        HttpUtils.Response resp = this.post(url, "application/cmisquery+xml", new HttpUtils.Output(){

            public void write(OutputStream out) throws Exception {
                JaxBHelper.marshal((JAXBElement)JaxBHelper.CMIS_OBJECT_FACTORY.createQuery(query), (OutputStream)out, (boolean)false);
            }
        });
        AtomFeed feed = this.parse(resp.getStream(), AtomFeed.class);
        for (AtomElement element : feed.getElements()) {
            if (element.getObject() instanceof AtomLink) {
                if (!this.isNextLink(element)) continue;
                result.setHasMoreItems(Boolean.TRUE);
                continue;
            }
            if (!this.isInt("numItems", element)) continue;
            result.setNumItems((BigInteger)element.getObject());
        }
        if (!feed.getEntries().isEmpty()) {
            result.setObjects(new ArrayList(feed.getEntries().size()));
            for (AtomEntry entry : feed.getEntries()) {
                ObjectData hit = null;
                for (AtomElement element : entry.getElements()) {
                    if (!(element.getObject() instanceof CmisObjectType)) continue;
                    hit = Converter.convert((CmisObjectType)((CmisObjectType)element.getObject()));
                }
                if (hit == null) continue;
                result.getObjects().add(hit);
            }
        }
        return result;
    }
}

