/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.browser;

import java.io.OutputStream;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.AbstractBrowserBindingService;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.ClientTypeCacheImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.FormDataWriter;
import org.apache.chemistry.opencmis.client.bindings.spi.http.HttpUtils;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FailedToDeleteDataImpl;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectServiceImpl
extends AbstractBrowserBindingService
implements ObjectService {
    public ObjectServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        UrlBuilder url = folderId != null ? this.getObjectUrl(repositoryId, folderId) : this.getRepositoryUrl(repositoryId);
        final FormDataWriter formData = new FormDataWriter("createDocument", contentStream);
        formData.addPropertiesParameters(properties);
        formData.addParameter("versioningState", versioningState);
        formData.addPoliciesParameters(policies);
        formData.addAddAcesParameters(addAces);
        formData.addRemoveAcesParameters(removeAces);
        formData.addSuccinctFlag(this.getSuccinct());
        HttpUtils.Response resp = this.post(url, formData.getContentType(), new HttpUtils.Output(){

            public void write(OutputStream out) throws Exception {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        ObjectData newObj = JSONConverter.convertObject(json, (TypeCache)typeCache);
        return newObj == null ? null : newObj.getId();
    }

    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        UrlBuilder url = folderId != null ? this.getObjectUrl(repositoryId, folderId) : this.getRepositoryUrl(repositoryId);
        final FormDataWriter formData = new FormDataWriter("createDocumentFromSource");
        formData.addParameter("sourceId", sourceId);
        formData.addPropertiesParameters(properties);
        formData.addParameter("versioningState", versioningState);
        formData.addPoliciesParameters(policies);
        formData.addAddAcesParameters(addAces);
        formData.addRemoveAcesParameters(removeAces);
        formData.addSuccinctFlag(this.getSuccinct());
        HttpUtils.Response resp = this.post(url, formData.getContentType(), new HttpUtils.Output(){

            public void write(OutputStream out) throws Exception {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        ObjectData newObj = JSONConverter.convertObject(json, (TypeCache)typeCache);
        return newObj == null ? null : newObj.getId();
    }

    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, folderId);
        final FormDataWriter formData = new FormDataWriter("createFolder");
        formData.addPropertiesParameters(properties);
        formData.addPoliciesParameters(policies);
        formData.addAddAcesParameters(addAces);
        formData.addRemoveAcesParameters(removeAces);
        formData.addSuccinctFlag(this.getSuccinct());
        HttpUtils.Response resp = this.post(url, formData.getContentType(), new HttpUtils.Output(){

            public void write(OutputStream out) throws Exception {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        ObjectData newObj = JSONConverter.convertObject(json, (TypeCache)typeCache);
        return newObj == null ? null : newObj.getId();
    }

    public String createRelationship(String repositoryId, Properties properties, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        UrlBuilder url = this.getRepositoryUrl(repositoryId);
        final FormDataWriter formData = new FormDataWriter("createRelationship");
        formData.addPropertiesParameters(properties);
        formData.addPoliciesParameters(policies);
        formData.addAddAcesParameters(addAces);
        formData.addRemoveAcesParameters(removeAces);
        formData.addSuccinctFlag(this.getSuccinct());
        HttpUtils.Response resp = this.post(url, formData.getContentType(), new HttpUtils.Output(){

            public void write(OutputStream out) throws Exception {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        ObjectData newObj = JSONConverter.convertObject(json, (TypeCache)typeCache);
        return newObj == null ? null : newObj.getId();
    }

    public String createPolicy(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        UrlBuilder url = folderId != null ? this.getObjectUrl(repositoryId, folderId) : this.getRepositoryUrl(repositoryId);
        final FormDataWriter formData = new FormDataWriter("createPolicy");
        formData.addPropertiesParameters(properties);
        formData.addPoliciesParameters(policies);
        formData.addAddAcesParameters(addAces);
        formData.addRemoveAcesParameters(removeAces);
        formData.addSuccinctFlag(this.getSuccinct());
        HttpUtils.Response resp = this.post(url, formData.getContentType(), new HttpUtils.Output(){

            public void write(OutputStream out) throws Exception {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        ObjectData newObj = JSONConverter.convertObject(json, (TypeCache)typeCache);
        return newObj == null ? null : newObj.getId();
    }

    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId, "allowableActions");
        HttpUtils.Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        return JSONConverter.convertAllowableActions(json);
    }

    public ObjectData getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId, "object");
        url.addParameter("filter", (Object)filter);
        url.addParameter("includeAllowableActions", (Object)includeAllowableActions);
        url.addParameter("includeRelationships", (Object)includeRelationships);
        url.addParameter("renditionFilter", (Object)renditionFilter);
        url.addParameter("includePolicyIds", (Object)includePolicyIds);
        url.addParameter("includeACL", (Object)includeAcl);
        url.addParameter("succinct", (Object)this.getSuccinctParameter());
        HttpUtils.Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        return JSONConverter.convertObject(json, (TypeCache)typeCache);
    }

    public ObjectData getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        UrlBuilder url = this.getPathUrl(repositoryId, path, "object");
        url.addParameter("filter", (Object)filter);
        url.addParameter("includeAllowableActions", (Object)includeAllowableActions);
        url.addParameter("includeRelationships", (Object)includeRelationships);
        url.addParameter("renditionFilter", (Object)renditionFilter);
        url.addParameter("includePolicyIds", (Object)includePolicyIds);
        url.addParameter("includeACL", (Object)includeAcl);
        url.addParameter("succinct", (Object)this.getSuccinctParameter());
        HttpUtils.Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        return JSONConverter.convertObject(json, (TypeCache)typeCache);
    }

    public Properties getProperties(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId, "properties");
        url.addParameter("filter", (Object)filter);
        url.addParameter("succinct", (Object)this.getSuccinctParameter());
        HttpUtils.Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        if (this.getSuccinct()) {
            ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
            return JSONConverter.convertSuccinctProperties(json, null, (TypeCache)typeCache);
        }
        return JSONConverter.convertProperties(json, null);
    }

    public List<RenditionData> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId, "renditions");
        url.addParameter("renditionFilter", (Object)renditionFilter);
        url.addParameter("maxItems", (Object)maxItems);
        url.addParameter("skipCount", (Object)skipCount);
        HttpUtils.Response resp = this.read(url);
        List<Object> json = this.parseArray(resp.getStream(), resp.getCharset());
        return JSONConverter.convertRenditions(json);
    }

    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        ContentStreamImpl result = new ContentStreamImpl();
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId, "content");
        url.addParameter("streamId", (Object)streamId);
        HttpUtils.Response resp = HttpUtils.invokeGET(url, this.getSession(), offset, length);
        if (resp.getResponseCode() != 200 && resp.getResponseCode() != 206) {
            throw this.convertStatusCode(resp.getResponseCode(), resp.getResponseMessage(), resp.getErrorContent(), null);
        }
        result.setFileName(null);
        result.setLength(resp.getContentLength());
        result.setMimeType(resp.getContentTypeHeader());
        result.setStream(resp.getStream());
        return result;
    }

    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Properties properties, ExtensionsData extension) {
        if (objectId == null || objectId.getValue() == null || ((String)objectId.getValue()).length() == 0) {
            throw new CmisInvalidArgumentException("Object id must be set!");
        }
        UrlBuilder url = this.getObjectUrl(repositoryId, (String)objectId.getValue());
        final FormDataWriter formData = new FormDataWriter("update");
        formData.addPropertiesParameters(properties);
        formData.addParameter("changeToken", changeToken == null ? null : (String)changeToken.getValue());
        formData.addSuccinctFlag(this.getSuccinct());
        HttpUtils.Response resp = this.post(url, formData.getContentType(), new HttpUtils.Output(){

            public void write(OutputStream out) throws Exception {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        ObjectData newObj = JSONConverter.convertObject(json, (TypeCache)typeCache);
        objectId.setValue((Object)(newObj == null ? null : newObj.getId()));
        if (changeToken != null && newObj.getProperties() != null) {
            Object ct = newObj.getProperties().getProperties().get("cmis:changeToken");
            changeToken.setValue((Object)(ct == null ? null : ct.toString()));
        }
    }

    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        if (objectId == null || objectId.getValue() == null || ((String)objectId.getValue()).length() == 0) {
            throw new CmisInvalidArgumentException("Object id must be set!");
        }
        UrlBuilder url = this.getObjectUrl(repositoryId, (String)objectId.getValue());
        final FormDataWriter formData = new FormDataWriter("move");
        formData.addParameter("targetFolderId", targetFolderId);
        formData.addParameter("sourceFolderId", sourceFolderId);
        formData.addSuccinctFlag(this.getSuccinct());
        HttpUtils.Response resp = this.post(url, formData.getContentType(), new HttpUtils.Output(){

            public void write(OutputStream out) throws Exception {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        ObjectData newObj = JSONConverter.convertObject(json, (TypeCache)typeCache);
        objectId.setValue((Object)(newObj == null ? null : newObj.getId()));
    }

    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId);
        final FormDataWriter formData = new FormDataWriter("delete");
        formData.addParameter("allVersions", allVersions);
        this.postAndConsume(url, formData.getContentType(), new HttpUtils.Output(){

            public void write(OutputStream out) throws Exception {
                formData.write(out);
            }
        });
    }

    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, folderId);
        final FormDataWriter formData = new FormDataWriter("deleteTree");
        formData.addParameter("allVersions", allVersions);
        formData.addParameter("unfileObjects", unfileObjects);
        formData.addParameter("continueOnFailure", continueOnFailure);
        HttpUtils.Response resp = this.post(url, formData.getContentType(), new HttpUtils.Output(){

            public void write(OutputStream out) throws Exception {
                formData.write(out);
            }
        });
        if (!BigInteger.ZERO.equals(resp.getContentLength())) {
            Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
            return JSONConverter.convertFailedToDelete(json);
        }
        return new FailedToDeleteDataImpl();
    }

    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        if (objectId == null || objectId.getValue() == null || ((String)objectId.getValue()).length() == 0) {
            throw new CmisInvalidArgumentException("Object id must be set!");
        }
        UrlBuilder url = this.getObjectUrl(repositoryId, (String)objectId.getValue());
        final FormDataWriter formData = new FormDataWriter("setContent", contentStream);
        formData.addParameter("overwriteFlag", overwriteFlag);
        formData.addParameter("changeToken", changeToken == null ? null : (String)changeToken.getValue());
        formData.addSuccinctFlag(this.getSuccinct());
        HttpUtils.Response resp = this.post(url, formData.getContentType(), new HttpUtils.Output(){

            public void write(OutputStream out) throws Exception {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        ObjectData newObj = JSONConverter.convertObject(json, (TypeCache)typeCache);
        objectId.setValue((Object)(newObj == null ? null : newObj.getId()));
        if (changeToken != null && newObj.getProperties() != null) {
            Object ct = newObj.getProperties().getProperties().get("cmis:changeToken");
            changeToken.setValue((Object)(ct == null ? null : ct.toString()));
        }
    }

    public void deleteContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ExtensionsData extension) {
        if (objectId == null || objectId.getValue() == null || ((String)objectId.getValue()).length() == 0) {
            throw new CmisInvalidArgumentException("Object id must be set!");
        }
        UrlBuilder url = this.getObjectUrl(repositoryId, (String)objectId.getValue());
        final FormDataWriter formData = new FormDataWriter("deleteContent");
        formData.addParameter("changeToken", changeToken == null ? null : (String)changeToken.getValue());
        formData.addSuccinctFlag(this.getSuccinct());
        HttpUtils.Response resp = this.post(url, formData.getContentType(), new HttpUtils.Output(){

            public void write(OutputStream out) throws Exception {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        ObjectData newObj = JSONConverter.convertObject(json, (TypeCache)typeCache);
        objectId.setValue((Object)(newObj == null ? null : newObj.getId()));
        if (changeToken != null && newObj.getProperties() != null) {
            Object ct = newObj.getProperties().getProperties().get("cmis:changeToken");
            changeToken.setValue((Object)(ct == null ? null : ct.toString()));
        }
    }
}

