/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.ACLService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.DiscoveryService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.MultiFilingService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.NavigationService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.ObjectService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.PolicyService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RelationshipService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RepositoryService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RepositoryServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.VersioningService;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class WebSpherePortProvider
extends AbstractPortProvider {
    private static final Logger log = LoggerFactory.getLogger(WebSpherePortProvider.class);

    protected Object createPortObject(Service service) {
        RepositoryServicePort portObject;
        if (log.isDebugEnabled()) {
            log.debug("Creating Web Service port object of " + (service == null ? "???" : service.getServiceName()) + "...");
        }
        try {
            int readTimeout;
            if (service instanceof RepositoryService) {
                portObject = ((RepositoryService)service).getRepositoryServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else if (service instanceof NavigationService) {
                portObject = ((NavigationService)service).getNavigationServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else if (service instanceof ObjectService) {
                portObject = ((ObjectService)service).getObjectServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else if (service instanceof VersioningService) {
                portObject = ((VersioningService)service).getVersioningServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else if (service instanceof DiscoveryService) {
                portObject = ((DiscoveryService)service).getDiscoveryServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else if (service instanceof MultiFilingService) {
                portObject = ((MultiFilingService)service).getMultiFilingServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else if (service instanceof RelationshipService) {
                portObject = ((RelationshipService)service).getRelationshipServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else if (service instanceof PolicyService) {
                portObject = ((PolicyService)service).getPolicyServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else if (service instanceof ACLService) {
                portObject = ((ACLService)service).getACLServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else {
                throw new CmisRuntimeException("Cannot find Web Services service object!");
            }
            AuthenticationProvider authProvider = CmisBindingsHelper.getAuthenticationProvider(this.getSession());
            Map httpHeaders = null;
            if (authProvider != null) {
                Element soapHeader = authProvider.getSOAPHeaders((Object)portObject);
                if (soapHeader != null) {
                    TransformerFactory transFactory = TransformerFactory.newInstance();
                    Transformer transformer = transFactory.newTransformer();
                    StringWriter headerXml = new StringWriter();
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.transform(new DOMSource(soapHeader), new StreamResult(headerXml));
                    HashMap<QName, List<String>> header = new HashMap<QName, List<String>>();
                    header.put(new QName(soapHeader.getNamespaceURI(), soapHeader.getLocalName()), Collections.singletonList(headerXml.toString()));
                    ((BindingProvider)portObject).getRequestContext().put("jaxws.binding.soap.headers.outbound", header);
                }
                httpHeaders = authProvider.getHTTPHeaders(service.getWSDLDocumentLocation().toString());
            }
            this.setHTTPHeaders(portObject, httpHeaders);
            int connectTimeout = this.getSession().get("org.apache.chemistry.opencmis.binding.connecttimeout", -1);
            if (connectTimeout >= 0) {
                ((BindingProvider)portObject).getRequestContext().put("connection_timeout", connectTimeout);
            }
            if ((readTimeout = this.getSession().get("org.apache.chemistry.opencmis.binding.readtimeout", -1)) >= 0) {
                ((BindingProvider)portObject).getRequestContext().put("request_timeout", readTimeout);
            }
        }
        catch (CmisBaseException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CmisConnectionException("Cannot initalize Web Services port object: " + e.getMessage(), (Throwable)e);
        }
        return portObject;
    }
}

